ItemEvents.entityInteracted(event => {
  const player = event.player;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const targetEntity = event.target;
  const item = event.item;
  if (player.persistentData.orcLordTriggered) return;
  if (targetEntity && targetEntity.type === 'tensura:orc' && item && item.id === 'tensura:marionette_heart') {
    const orcLord = level.createEntity('tensura:orc_lord');
    if (orcLord) {
      orcLord.setPosition(targetEntity.x, targetEntity.y, targetEntity.z);
      orcLord.spawn();
      targetEntity.kill();
      player.tell(Text.translate('kubejs.story.orc_lord.summon'));
      item.count--;
      player.persistentData.orcLordTriggered = true;
      event.cancel();
    }
  }
});
