PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(10, true);
  if (rayTraceResult && rayTraceResult.block) {
    let blockId = rayTraceResult.block.id;
    if ((blockId === 'tensura:magic_ore' || blockId === 'tensura:deepslate_magic_ore') && !player.persistentData.seenMagicOre) {
      player.persistentData.seenMagicOre = true;
      player.tell(Text.translate('kubejs.story.magic_ore.discovery'));
      server.scheduleInTicks(40, _ => {
        player.tell(Text.translate('kubejs.story.magic_ore.benefit'));
      });
    }
  }
});
