PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  
  let entityResult = player.rayTrace(50, false);
  if (entityResult && entityResult.entity && entityResult.entity.type === 'tensura_neb:luminous_valentine') {
    let currentLuminous = entityResult.entity;
    
    if (!player.persistentData.seenLuminousValentine) {
      player.persistentData.seenLuminousValentine = true;
      player.tell(Text.translate('kubejs.story.luminous_valentine.greeting'));
      
      server.scheduleInTicks(40, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.luminous_valentine.threat'));
        }
      });
      
      server.scheduleInTicks(80, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.luminous_valentine.blood_thirst'));
        }
      });
    }
    
    if (currentLuminous.health < 10000 && currentLuminous.health >= 2000 && !currentLuminous.persistentData.hasLowHealthDialog1) {
      currentLuminous.persistentData.hasLowHealthDialog1 = true;
      player.tell(Text.translate('kubejs.story.luminous_valentine.annoyed'));
    }
    
    if (currentLuminous.health < 2000 && !currentLuminous.persistentData.hasLowHealthDialog2) {
      currentLuminous.persistentData.hasLowHealthDialog2 = true;
      player.tell(Text.translate('kubejs.story.luminous_valentine.desperation'));
      
      server.scheduleInTicks(40, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.luminous_valentine.prayer'));
        }
      });
    }
  } 
  else if (!player.persistentData.luminousRemoved && player.persistentData.seenLuminousValentine) {
    player.persistentData.luminousRemoved = true;
    if (player.world) {
      player.world.tell(Text.translate('kubejs.story.luminous_valentine.defeat'));
      
      server.scheduleInTicks(20, _ => {
        if (player.world) {
          player.world.tell(Text.translate('kubejs.story.luminous_valentine.world_voice'));
        }
      });
    }
  }
});
