PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  let hasMagicCrystal = false;
  player.inventory.items.forEach(item => {
    if (item && item.id === 'tensura:low_quality_magic_crystal') {
      hasMagicCrystal = true;
    }
  });
  if (hasMagicCrystal) {
    if (player.persistentData.hasSeenMagicCrystalDialog) return;
    player.persistentData.hasSeenMagicCrystalDialog = true;
    player.tell(Text.translate('kubejs.story.magic_crystal.congratulations'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.magic_crystal.drop_info')));
    server.scheduleInTicks(80, _ => player.tell(Text.translate('kubejs.story.magic_crystal.my_thought')));
    server.scheduleInTicks(120, _ => player.tell(Text.translate('kubejs.story.magic_crystal.usage')));
  }
});
