PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(70, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:lizardman') {
    if (player.persistentData.seenLizardman) return;
    player.persistentData.seenLizardman = true;
    player.tell(Text.translate('kubejs.story.lizardman.intro'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.lizardman.structures')));
  }
});
