PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  if (level.dimension === 'tensura:labyrinth') return;
  const rayTraceResult = player.rayTrace(60, true);
  if (rayTraceResult && rayTraceResult.block && rayTraceResult.block.id === 'tensura:labyrinth_portal') {
    if (player.persistentData.seenLabyrinthPortal) return;
    player.persistentData.seenLabyrinthPortal = true;
    player.tell(Text.translate('kubejs.story.labyrinth_portal.greeting'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.labyrinth_portal.requirement')));
    server.scheduleInTicks(80, _ => player.tell(Text.translate('kubejs.story.labyrinth_portal.boss_info')));
    server.scheduleInTicks(120, _ => player.tell(Text.translate('kubejs.story.labyrinth_portal.narrator_hint')));
  }
});
