PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  if (level.dimension === 'tensura:labyrinth') {
    if (!player.persistentData.hasEnteredLabyrinth) {
      player.persistentData.hasEnteredLabyrinth = true;
      player.tell(Text.translate('kubejs.story.labyrinth.intro'));
      server.scheduleInTicks(80, _ => player.tell(Text.translate('kubejs.story.labyrinth.corridor')));
    }
    let slabResult = player.rayTrace(30, true);
    if (slabResult && slabResult.block && slabResult.block.id === 'tensura:labyrinth_light_path_slab' && !player.persistentData.seenCrystalStairs) {
      player.persistentData.seenCrystalStairs = true;
      player.tell(Text.translate('kubejs.story.labyrinth.crystal_stairs'));
    }
    let barrierResult = player.rayTrace(100, true);
    if (barrierResult && barrierResult.block && barrierResult.block.id === 'tensura:labyrinth_barrier_block' && !player.persistentData.seenLabyrinthBarrier) {
      player.persistentData.seenLabyrinthBarrier = true;
      player.tell(Text.translate('kubejs.story.labyrinth.barrier_guardian'));
      server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.labyrinth.barrier_warning')));
    }
    let crystalResult = player.rayTrace(80, true);
    if (crystalResult && crystalResult.block && crystalResult.block.id === 'tensura:labyrinth_crystal' && !player.persistentData.seenLabyrinthCrystal) {
      player.persistentData.seenLabyrinthCrystal = true;
      player.tell(Text.translate('kubejs.story.labyrinth.elves'));
      server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.labyrinth.friend')));
    }
  }
});
