PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(10, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:ifrit') {
    if (player.persistentData.seenIfrit) return;
    player.persistentData.seenIfrit = true;
    player.tell(Text.translate('kubejs.story.ifrit.challenge'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.ifrit.strategy')));
    server.scheduleInTicks(120, _ => player.tell(Text.translate('kubejs.story.ifrit.encouragement')));
  }
});
