PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(30, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:goblin') {
    if (player.persistentData.seenGoblin) return;
    player.persistentData.seenGoblin = true;
    player.tell(Text.translate('kubejs.story.goblin.my_reaction'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.goblin.world_voice_intro')));
    server.scheduleInTicks(80, _ => player.tell(Text.translate('kubejs.story.goblin.world_voice_loot')));
  }
});
