PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(5, true);
  if (rayTraceResult && rayTraceResult.block) {
    let blockId = rayTraceResult.block.id;
    if (blockId === 'iceandfire:ghost_chest' && !player.persistentData.seenGhostChest) {
      player.persistentData.seenGhostChest = true;
      player.tell(Text.translate('kubejs.story.ghost_chest.warning'));
    }
  }
});
