ServerEvents.commandRegistry(event => {
    const { commands: Commands } = event;
  
    event.register(
      Commands.literal('jor')
        .then(
          Commands.literal('cz')
            .executes(ctx => {
              const player = ctx.source.player;
              if (!player) {
                console.log('该命令必须由玩家执行！');
                return 0;
              }
  
              player.persistentData.group1Done = false;
              player.persistentData.group2FirstDone = false;
              player.persistentData.group2SecondDone = false;
              player.persistentData.group3SecondDone = false;
              player.persistentData.firstLoginDone = false;
              player.persistentData.difficultyChosen = false;
              player.persistentData.seenShizu = false;
              player.persistentData.ifritNearby = false;
              player.persistentData.seenSlime = false;
              player.persistentData.hasSeenMagicCrystalDialog = false;
              player.persistentData.seenSuperSlime = false;
              player.persistentData.seenOrcLord = false;
              player.persistentData.seenLabyrinthPortal = false;
              player.persistentData.hasEnteredLabyrinth = false;
              player.persistentData.seenCrystalStairs = false;
              player.persistentData.seenLabyrinthBarrier = false;
              player.persistentData.seenLabyrinthCrystal = false;
              player.persistentData.seenCharybdisCore = false;
              player.persistentData.seenElementalColossus = false;
              player.persistentData.colossusRemoved = false;
              player.persistentData.seenCharybdis = false;
              player.persistentData.seenGoblin = false;
              player.persistentData.seenLizardman = false;
              player.persistentData.seenSpiderEgg = false;
              player.persistentData.seenWebBlock = false;
              player.persistentData.seenMagicOre = false;
              player.persistentData.seenGhostChest = false;
              player.persistentData.hasEnteredEnd = false;
              player.persistentData.killedInOverworld = false;
              player.persistentData.hellIntroTriggered = false;
              player.persistentData.orcLordTriggered = false;
              player.persistentData.seenOrc = false;
              player.persistentData.direwolfTriggered = false;
              player.persistentData.seenDirewolf = false;
              player.tell(Text.translate('kubejs.message.reset_choices'));
              return 1;
            })
        )
        .then(
          Commands.literal('resetServer')
            .executes(ctx => {
              const server = ctx.source.server;
              server.persistentData.initDone = false;
              server.tell(Text.translate('kubejs.message.reset_server'));
              return 1;
            })
        )
    );
  
    event.register(
      Commands.literal('story_choice1')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice1 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group1Done) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group1Done = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:czh master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.why_here'));
          ctx.source.server.scheduleInTicks(100, _ => {
            scheduleSharedStory(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_choice2')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice2 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group1Done) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group1Done = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:jsbqc master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.maybe_kind_person'));
          ctx.source.server.scheduleInTicks(60, _ => {
            scheduleSharedStory(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_choice3')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice3 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group2SecondDone) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group2SecondDone = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:msbkhq master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.about_magic'));
          ctx.source.server.scheduleInTicks(195, _ => {
            sendOptionOnlyFeelChoices(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_choice4')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice4 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group2SecondDone) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group2SecondDone = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:lwdw master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.understand_well'));
          ctx.source.server.scheduleInTicks(45, _ => {
            scheduleEndingStory(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_choice6')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice6 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group3SecondDone) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group3SecondDone = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:lwdw master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.understand_well'));
          ctx.source.server.scheduleInTicks(45, _ => {
            scheduleEndingStory(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_choice7')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice7 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group3SecondDone) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group3SecondDone = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:mgx master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.rely_on_self'));
          ctx.source.server.scheduleInTicks(45, _ => {
            scheduleEndingStory(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_choice5')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_choice5 命令必须由玩家执行！');
            return 0;
          }
  
          if (player.persistentData.group2SecondDone) {
            player.tell(Text.translate('kubejs.message.already_chosen'));
            return 1;
          }
  
          player.persistentData.group2SecondDone = true;
          ctx.source.server.runCommand(`playsound ablazeaqzlmu:mgx master ${player.name.string} ~ ~ ~ 10 1`);
          player.tell(Text.translate('kubejs.story.rely_on_self'));
          ctx.source.server.scheduleInTicks(45, _ => {
            scheduleEndingStory(player, ctx.source.server);
          });
          return 1;
        })
    );
  
    event.register(
      Commands.literal('story_difficulty_easy')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_difficulty_easy 命令必须由玩家执行！');
            return 0;
          }
          
          if (player.persistentData.difficultyChosen) {
            player.tell(Text.translate('kubejs.message.already_chosen_difficulty'));
            return 1;
          }
          
          player.persistentData.difficultyChosen = true;
          
          ctx.source.server.runCommand(`gamerule epDeathPenalty 2`);
          ctx.source.server.runCommand(`tensura edit ${player.name.string} stat EP add 1000`);
          
          finishStoryWithDifficulty(player, ctx.source.server, Text.translate('kubejs.difficulty.easy'));
          return 1;
        })
    );
    
    event.register(
      Commands.literal('story_difficulty_normal')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_difficulty_normal 命令必须由玩家执行！');
            return 0;
          }
          
          if (player.persistentData.difficultyChosen) {
            player.tell(Text.translate('kubejs.message.already_chosen_difficulty'));
            return 1;
          }
          
          player.persistentData.difficultyChosen = true;
          
          finishStoryWithDifficulty(player, ctx.source.server, Text.translate('kubejs.difficulty.normal'));
          return 1;
        })
    );
    
    event.register(
      Commands.literal('story_difficulty_hard')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_difficulty_hard 命令必须由玩家执行！');
            return 0;
          }
          
          if (player.persistentData.difficultyChosen) {
            player.tell(Text.translate('kubejs.message.already_chosen_difficulty'));
            return 1;
          }
          
          player.persistentData.difficultyChosen = true;
          
          ctx.source.server.runCommand(`gamerule epDeathPenalty 9`);
          
          finishStoryWithDifficulty(player, ctx.source.server, Text.translate('kubejs.difficulty.hard'));
          return 1;
        })
    );
    
    event.register(
      Commands.literal('story_difficulty_hardcore')
        .executes(ctx => {
          const player = ctx.source.player;
          if (!player) {
            console.log('story_difficulty_hardcore 命令必须由玩家执行！');
            return 0;
          }
          
          if (player.persistentData.difficultyChosen) {
            player.tell(Text.translate('kubejs.message.already_chosen_difficulty'));
            return 1;
          }
          
          player.persistentData.difficultyChosen = true;
          
          ctx.source.server.runCommand(`gamerule epDeathPenalty 18`);
          
          finishStoryWithDifficulty(player, ctx.source.server, Text.translate('kubejs.difficulty.hardcore'));
          return 1;
        })
    );
  });
  
  PlayerEvents.loggedIn(event => {
    const server = event.server;
    const player = event.player;
  
    if (!server.persistentData.initDone) {
      server.runCommand(`gamerule sendCommandFeedback false`);
      server.runCommand(`difficulty peaceful`);
      server.persistentData.initDone = true;
    }
  
  const playerData = player.persistentData;
  const hasCompletedStory = playerData.difficultyChosen;
  
  if (!hasCompletedStory) {
    if (playerData.firstLoginDone) {
      if (playerData.group1Done && !playerData.group2SecondDone) {
        server.scheduleInTicks(20, _ => {
          sendOption2(player, server);
        });
        return;
      } else if (playerData.group2SecondDone && !playerData.difficultyChosen) {
        server.scheduleInTicks(20, _ => {
          player.tell(Text.translate('kubejs.story.choose_difficulty'));
          server.scheduleInTicks(20, _ => {
            sendDifficultyOptions(player, server);
          });
        });
        return;
      }
    }
      showStoryTitle(player);
      
      playerData.difficultyChosen = false;
      
      server.scheduleInTicks(1, _ => {
        server.runCommand(`effect give ${player.name.string} minecraft:blindness 99999 9 true`);
        server.runCommand(`effect give ${player.name.string} minecraft:regeneration 99999 9 true`);
        server.runCommand(`effect give ${player.name.string} minecraft:slowness 99999 9 true`);
        server.runCommand(`effect give ${player.name.string} minecraft:mining_fatigue 99999 9 true`);
        server.runCommand(`effect give ${player.name.string} minecraft:darkness 99999 9 true`);
      });
  
      server.scheduleInTicks(60, _ => {
        server.runCommand(`playsound ablazeaqzlmu:jr10 master ${player.name.string} ~ ~ ~ 10 1`);
    });
  
      server.scheduleInTicks(61, _ => {
        player.tell(Text.translate('kubejs.story.wake_up'));
      });
  
      server.scheduleInTicks(80, _ => {
        player.tell(Text.translate('kubejs.story.who_where'));
      });
  
      server.scheduleInTicks(115, _ => {
        server.runCommand(`playsound ablazeaqzlmu:jr11 master ${player.name.string} ~ ~ ~ 10 1`);
      });
  
      server.scheduleInTicks(116, _ => {
        player.tell(Text.translate('kubejs.story.guide_intro'));
      });
  
      server.scheduleInTicks(220, _ => {
        sendOption1(player, server);
      });
  
      playerData.firstLoginDone = true;
    }
  });
  
  function showStoryTitle(player) {
    const server = player.server;
    server.runCommand(`title ${player.name.string} times 20 999999 20`);
    server.runCommand(`title ${player.name.string} title {"translate":"kubejs.title.open_chat_for_story","color":"yellow"}`);
  }
  
  function clearStoryTitle(player) {
    const server = player.server;
    server.runCommand(`title ${player.name.string} clear`);
  }
  
  function scheduleSharedStory(player, server) {
    server.scheduleInTicks(20, _ => {
      server.runCommand(`playsound ablazeaqzlmu:jr12 master ${player.name.string} ~ ~ ~ 10 1`);
      player.tell(Text.translate('kubejs.story.new_world'));
    });
  
    server.scheduleInTicks(140, _ => {
      server.runCommand(`playsound ablazeaqzlmu:jr13 master ${player.name.string} ~ ~ ~ 10 1`);
      player.tell(Text.translate('kubejs.story.introduction'));
    });
  
    server.scheduleInTicks(595, _ => {
      sendOption2(player, server);
    });
  }
  
  function sendOption1(player, server) {
    const msgJson = JSON.stringify({
      text: "",
      extra: [
        {
          translate: "kubejs.option.why_wilderness",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice1" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        },
        { text: "   " },
        {
          translate: "kubejs.option.why_strange_clothes",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice2" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        }
      ]
    });
    server.runCommand(`tellraw ${player.name.string} ${msgJson}`);
  }
  
  function sendOptionOnlyFeelChoices(player, server) {
    const msgJson = JSON.stringify({
      text: "",
      extra: [
        {
          translate: "kubejs.option.feel_strong_magic",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice6" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        },
        { text: "   " },
        {
          translate: "kubejs.option.feel_weak_magic",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice7" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        }
      ]
    });
    server.runCommand(`tellraw ${player.name.string} ${msgJson}`);
  }
  
  function sendOption2(player, server) {
    const msgJson = JSON.stringify({
      text: "",
      extra: [
        {
          translate: "kubejs.option.dont_understand",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice3" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        },
        { text: "   " },
        {
          translate: "kubejs.option.feel_strong_magic",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice4" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        },
        { text: "   " },
        {
          translate: "kubejs.option.feel_weak_magic",
          color: "aqua",
          clickEvent: { action: "run_command", value: "/story_choice5" },
          hoverEvent: { action: "show_text", translate: "kubejs.option.select_this" }
        }
      ]
    });
    server.runCommand(`tellraw ${player.name.string} ${msgJson}`);
  }
  
  function scheduleEndingStory(player, server) {
    server.scheduleInTicks(40, _ => {
      server.runCommand(`playsound ablazeaqzlmu:jrd1 master ${player.name.string} ~ ~ ~ 10 1`);
      player.tell(Text.translate('kubejs.story.help_you'));
    });
  
    server.scheduleInTicks(95, _ => {
      player.tell(Text.translate('kubejs.story.want_more'));
    });
  
    server.scheduleInTicks(120, _ => {
      server.runCommand(`playsound ablazeaqzlmu:jrd2 master ${player.name.string} ~ ~ ~ 10 1`);
      player.tell(Text.translate('kubejs.story.reassure'));
    });
  
    server.scheduleInTicks(140, _ => {
      player.tell(Text.translate('kubejs.story.not_better'));
    });
  
    server.scheduleInTicks(185, _ => {
      player.tell(Text.translate('kubejs.story.about_ring'));
    });
  
    server.scheduleInTicks(225, _ => {
	  server.runCommand(`playsound ablazeaqzlmu:ksts master ${player.name.string} ~ ~ ~ 10 1`);
      player.tell(Text.translate('kubejs.story.begin_adventure'));
    });
    
    server.scheduleInTicks(300, _ => {
      player.tell(Text.translate('kubejs.story.choose_difficulty'));
      
      server.scheduleInTicks(20, _ => {
        sendDifficultyOptions(player, server);
      });
    });
  }
  
  function sendDifficultyOptions(player, server) {
    const msgJson = JSON.stringify({
      text: "",
      extra: [
        {
          translate: "kubejs.difficulty.option.easy",
          color: "green",
          clickEvent: { action: "run_command", value: "/story_difficulty_easy" },
          hoverEvent: { action: "show_text", translate: "kubejs.difficulty.select_easy" }
        },
        { text: "   " },
        {
          translate: "kubejs.difficulty.option.normal",
          color: "white",
          clickEvent: { action: "run_command", value: "/story_difficulty_normal" },
          hoverEvent: { action: "show_text", translate: "kubejs.difficulty.select_normal" }
        },
        { text: "   " },
        {
          translate: "kubejs.difficulty.option.hard",
          color: "dark_red",
          clickEvent: { action: "run_command", value: "/story_difficulty_hard" },
          hoverEvent: { action: "show_text", translate: "kubejs.difficulty.select_hard" }
        },
        { text: "   " },
        {
          translate: "kubejs.difficulty.option.hardcore",
          color: "red",
          clickEvent: { action: "run_command", value: "/story_difficulty_hardcore" },
          hoverEvent: { action: "show_text", translate: "kubejs.difficulty.select_hardcore" }
        }
      ]
    });
    server.runCommand(`tellraw ${player.name.string} ${msgJson}`);
  }
  
  function finishStoryWithDifficulty(player, server, difficultyName) {
    player.tell(Text.translate('kubejs.story.difficulty_chosen', [difficultyName]));
    
    clearStoryTitle(player);
  
    server.runCommand(`effect clear ${player.name.string} minecraft:blindness`);
    server.runCommand(`effect clear ${player.name.string} minecraft:regeneration`);
    server.runCommand(`effect clear ${player.name.string} minecraft:slowness`);
    server.runCommand(`effect clear ${player.name.string} minecraft:mining_fatigue`);
    server.runCommand(`effect clear ${player.name.string} minecraft:darkness`);
    server.runCommand(`tensura edit ${player.name.string} stat EP add 1000`);
    server.runCommand(`difficulty hard`);
    server.scheduleInTicks(5, _ => {
      server.runCommand(`gamerule sendCommandFeedback true`);
    });
  }
  