PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  let entityResult = player.rayTrace(50, false);
  if (entityResult && entityResult.entity && entityResult.entity.type === 'tensura:elemental_colossus') {
    let currentColossus = entityResult.entity;
    if (!player.persistentData.seenElementalColossus) {
      player.persistentData.seenElementalColossus = true;
      player.tell(Text.translate('kubejs.story.elemental_colossus.greeting'));
      server.scheduleInTicks(40, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.elemental_colossus.threat'));
        }
      });
      server.scheduleInTicks(80, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.elemental_colossus.my_reaction'));
        }
      });
      server.scheduleInTicks(100, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.elemental_colossus.warning'));
        }
      });
      server.scheduleInTicks(140, _ => {
        if (player && player.isAlive()) {
          player.tell(Text.translate('kubejs.story.elemental_colossus.attack_advice'));
        }
      });
    }
    if (currentColossus.health < 300 && !currentColossus.persistentData.hasLowHealthDialog) {
      currentColossus.persistentData.hasLowHealthDialog = true;
      player.tell(Text.translate('kubejs.story.elemental_colossus.angry'));
    }
  } else if (!player.persistentData.colossusRemoved && player.persistentData.seenElementalColossus) {
    player.persistentData.colossusRemoved = true;
    if (player.world) {
      player.world.tell(Text.translate('kubejs.story.elemental_colossus.defeat'));
      player.world.tell(Text.translate('kubejs.story.elemental_colossus.world_voice'));
    }
  }
});
