ItemEvents.entityInteracted(event => {
  const player = event.player;
  const targetEntity = event.target;
  const item = event.item;

  if (player.persistentData.direwolfTriggered) {
    return;
  }

  if (
    targetEntity &&
    targetEntity.type === 'tensura:direwolf' &&
    item && item.id === 'tensura:marionette_heart'
  ) {
    const posX = targetEntity.x;
    const posY = targetEntity.y;
    const posZ = targetEntity.z;

    event.server.runCommand(`/summon tensura:direwolf ${posX} ${posY} ${posZ} {Variant:13, Star:1}`);

    targetEntity.kill();

    player.tell(Text.translate('kubejs.story.direwolf.evolution_success'));

    item.count--;

    player.persistentData.direwolfTriggered = true;

    event.cancel();
  }
});
