PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(15, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:direwolf') {
    if (player.persistentData.seenDirewolf) return;
    player.persistentData.seenDirewolf = true;
    player.tell(Text.translate('kubejs.story.direwolf.intro'));
    server.scheduleInTicks(20, _ => player.tell(Text.translate('kubejs.story.direwolf.evolution_hint')));
  }
});
