PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const coreResult = player.rayTrace(40, true);
  if (coreResult && coreResult.block && coreResult.block.id === 'tensura:charybdis_core') {
    if (player.persistentData.seenCharybdisCore) return;
    player.persistentData.seenCharybdisCore = true;
    player.tell(Text.translate('kubejs.story.charybdis_core.found'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.charybdis_core.my_reaction')));
    server.scheduleInTicks(80, _ => player.tell(Text.translate('kubejs.story.charybdis_core.core_description')));
    server.scheduleInTicks(120, _ => player.tell(Text.translate('kubejs.story.charybdis_core.my_confusion')));
  }
});
