PlayerEvents.tick(event => {
  const player = event.player;
  const server = event.server;
  const level = player.level;
  const currentTick = level.time;
  if (currentTick % 20 !== 0) return;
  const rayTraceResult = player.rayTrace(100, false);
  if (rayTraceResult && rayTraceResult.entity && rayTraceResult.entity.type === 'tensura:charybdis') {
    if (player.persistentData.seenCharybdis) return;
    player.persistentData.seenCharybdis = true;
    player.tell(Text.translate('kubejs.story.charybdis.encounter'));
    server.scheduleInTicks(40, _ => player.tell(Text.translate('kubejs.story.charybdis.warning')));
    server.scheduleInTicks(80, _ => player.tell(Text.translate('kubejs.story.charybdis.caution')));
  }
});
