/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.progress;

import com.google.common.base.Ascii;
import com.google.common.base.CharMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class StartupMessageManager {
    private static volatile EnumMap<MessageType, List<Message>> messages = new EnumMap(MessageType.class);

    public static List<Pair<Integer, Message>> getMessages() {
        long ts = System.nanoTime();
        return messages.values().stream().flatMap(Collection::stream).sorted(Comparator.comparingLong(Message::getTimestamp).thenComparing(Message::getText).reversed()).map(m -> Pair.of((Object)((int)((double)(ts - m.timestamp) / 1000000.0)), (Object)m)).limit(5L).collect(Collectors.toList());
    }

    private static synchronized void addMessage(MessageType type, String message, int maxSize) {
        EnumMap<MessageType, List<Message>> newMessages = new EnumMap<MessageType, List<Message>>(messages);
        newMessages.compute(type, (key, existingList) -> {
            ArrayList newList = new ArrayList();
            if (existingList != null) {
                if (maxSize < 0) {
                    newList.addAll(existingList);
                } else {
                    newList.addAll(existingList.subList(0, Math.min(existingList.size(), maxSize)));
                }
            }
            newList.add(new Message(message, type));
            return newList;
        });
        messages = newMessages;
    }

    public static void addModMessage(String message) {
        String safeMessage = Ascii.truncate((CharSequence)CharMatcher.ascii().retainFrom((CharSequence)message), (int)80, (String)"~");
        StartupMessageManager.addMessage(MessageType.MOD, safeMessage, 20);
    }

    public static Optional<Consumer<String>> modLoaderConsumer() {
        return Optional.of(s -> StartupMessageManager.addMessage(MessageType.ML, s, -1));
    }

    public static Optional<Consumer<String>> locatorConsumer() {
        return Optional.of(s -> StartupMessageManager.addMessage(MessageType.LOC, s, -1));
    }

    public static Optional<Consumer<String>> mcLoaderConsumer() {
        return Optional.of(s -> StartupMessageManager.addMessage(MessageType.MC, s, -1));
    }

    static enum MessageType {
        MC(1.0f, 1.0f, 1.0f),
        ML(0.0f, 0.0f, 0.5f),
        LOC(0.0f, 0.5f, 0.0f),
        MOD(0.5f, 0.0f, 0.0f);

        private final float[] colour;

        private MessageType(float r, float g, float b) {
            this.colour = new float[]{r, g, b};
        }

        public float[] colour() {
            return this.colour;
        }
    }

    public static class Message {
        private final String text;
        private final MessageType type;
        private final long timestamp;

        public Message(String text, MessageType type) {
            this.text = text;
            this.type = type;
            this.timestamp = System.nanoTime();
        }

        public String getText() {
            return this.text;
        }

        MessageType getType() {
            return this.type;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        public float[] getTypeColour() {
            return this.type.colour();
        }
    }
}

