/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.event.ForgeEventFactory;

public class WoodlandMansionPieces {
    public static void m_229985_(StructureTemplateManager p_229986_, BlockPos p_229987_, Rotation p_229988_, List<WoodlandMansionPiece> p_229989_, RandomSource p_229990_) {
        MansionGrid woodlandmansionpieces$mansiongrid = new MansionGrid(p_229990_);
        MansionPiecePlacer woodlandmansionpieces$mansionpieceplacer = new MansionPiecePlacer(p_229986_, p_229990_);
        woodlandmansionpieces$mansionpieceplacer.m_230080_(p_229987_, p_229988_, p_229989_, woodlandmansionpieces$mansiongrid);
    }

    public static void main(String[] p_229992_) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = randomsource.m_188505_();
        System.out.println("Seed: " + i);
        randomsource.m_188584_(i);
        MansionGrid woodlandmansionpieces$mansiongrid = new MansionGrid(randomsource);
        woodlandmansionpieces$mansiongrid.m_230044_();
    }

    static class MansionGrid {
        private static final int f_230020_ = 11;
        private static final int f_230021_ = 0;
        private static final int f_230022_ = 1;
        private static final int f_230023_ = 2;
        private static final int f_230024_ = 3;
        private static final int f_230025_ = 4;
        private static final int f_230026_ = 5;
        private static final int f_230027_ = 65536;
        private static final int f_230028_ = 131072;
        private static final int f_230029_ = 262144;
        private static final int f_230030_ = 0x100000;
        private static final int f_230031_ = 0x200000;
        private static final int f_230032_ = 0x400000;
        private static final int f_230033_ = 0x800000;
        private static final int f_230034_ = 983040;
        private static final int f_230035_ = 65535;
        private final RandomSource f_230036_;
        final SimpleGrid f_230037_;
        final SimpleGrid f_230038_;
        final SimpleGrid[] f_230039_;
        final int f_230040_;
        final int f_230041_;

        public MansionGrid(RandomSource p_230043_) {
            this.f_230036_ = p_230043_;
            int i = 11;
            this.f_230040_ = 7;
            this.f_230041_ = 4;
            this.f_230037_ = new SimpleGrid(11, 11, 5);
            this.f_230037_.m_230179_(this.f_230040_, this.f_230041_, this.f_230040_ + 1, this.f_230041_ + 1, 3);
            this.f_230037_.m_230179_(this.f_230040_ - 1, this.f_230041_, this.f_230040_ - 1, this.f_230041_ + 1, 2);
            this.f_230037_.m_230179_(this.f_230040_ + 2, this.f_230041_ - 2, this.f_230040_ + 3, this.f_230041_ + 3, 5);
            this.f_230037_.m_230179_(this.f_230040_ + 1, this.f_230041_ - 2, this.f_230040_ + 1, this.f_230041_ - 1, 1);
            this.f_230037_.m_230179_(this.f_230040_ + 1, this.f_230041_ + 2, this.f_230040_ + 1, this.f_230041_ + 3, 1);
            this.f_230037_.m_230170_(this.f_230040_ - 1, this.f_230041_ - 1, 1);
            this.f_230037_.m_230170_(this.f_230040_ - 1, this.f_230041_ + 2, 1);
            this.f_230037_.m_230179_(0, 0, 11, 1, 5);
            this.f_230037_.m_230179_(0, 9, 11, 11, 5);
            this.m_230057_(this.f_230037_, this.f_230040_, this.f_230041_ - 2, Direction.WEST, 6);
            this.m_230057_(this.f_230037_, this.f_230040_, this.f_230041_ + 3, Direction.WEST, 6);
            this.m_230057_(this.f_230037_, this.f_230040_ - 2, this.f_230041_ - 1, Direction.WEST, 3);
            this.m_230057_(this.f_230037_, this.f_230040_ - 2, this.f_230041_ + 2, Direction.WEST, 3);
            while (this.m_230045_(this.f_230037_)) {
            }
            this.f_230039_ = new SimpleGrid[3];
            this.f_230039_[0] = new SimpleGrid(11, 11, 5);
            this.f_230039_[1] = new SimpleGrid(11, 11, 5);
            this.f_230039_[2] = new SimpleGrid(11, 11, 5);
            this.m_230063_(this.f_230037_, this.f_230039_[0]);
            this.m_230063_(this.f_230037_, this.f_230039_[1]);
            this.f_230039_[0].m_230179_(this.f_230040_ + 1, this.f_230041_, this.f_230040_ + 1, this.f_230041_ + 1, 0x800000);
            this.f_230039_[1].m_230179_(this.f_230040_ + 1, this.f_230041_, this.f_230040_ + 1, this.f_230041_ + 1, 0x800000);
            this.f_230038_ = new SimpleGrid(this.f_230037_.f_230160_, this.f_230037_.f_230161_, 5);
            this.m_230066_();
            this.m_230063_(this.f_230038_, this.f_230039_[2]);
        }

        public static boolean m_230047_(SimpleGrid p_230048_, int p_230049_, int p_230050_) {
            int i = p_230048_.m_230167_(p_230049_, p_230050_);
            return i == 1 || i == 2 || i == 3 || i == 4;
        }

        public boolean m_230051_(SimpleGrid p_230052_, int p_230053_, int p_230054_, int p_230055_, int p_230056_) {
            return (this.f_230039_[p_230055_].m_230167_(p_230053_, p_230054_) & 0xFFFF) == p_230056_;
        }

        @Nullable
        public Direction m_230067_(SimpleGrid p_230068_, int p_230069_, int p_230070_, int p_230071_, int p_230072_) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (!this.m_230051_(p_230068_, p_230069_ + direction.m_122429_(), p_230070_ + direction.m_122431_(), p_230071_, p_230072_)) continue;
                return direction;
            }
            return null;
        }

        private void m_230057_(SimpleGrid p_230058_, int p_230059_, int p_230060_, Direction p_230061_, int p_230062_) {
            if (p_230062_ > 0) {
                p_230058_.m_230170_(p_230059_, p_230060_, 1);
                p_230058_.m_230174_(p_230059_ + p_230061_.m_122429_(), p_230060_ + p_230061_.m_122431_(), 0, 1);
                for (int i = 0; i < 8; ++i) {
                    Direction direction = Direction.m_122407_((int)this.f_230036_.m_188503_(4));
                    if (direction == p_230061_.m_122424_() || direction == Direction.EAST && this.f_230036_.m_188499_()) continue;
                    int j = p_230059_ + p_230061_.m_122429_();
                    int k = p_230060_ + p_230061_.m_122431_();
                    if (p_230058_.m_230167_(j + direction.m_122429_(), k + direction.m_122431_()) != 0 || p_230058_.m_230167_(j + direction.m_122429_() * 2, k + direction.m_122431_() * 2) != 0) continue;
                    this.m_230057_(p_230058_, p_230059_ + p_230061_.m_122429_() + direction.m_122429_(), p_230060_ + p_230061_.m_122431_() + direction.m_122431_(), direction, p_230062_ - 1);
                    break;
                }
                Direction direction1 = p_230061_.m_122427_();
                Direction direction2 = p_230061_.m_122428_();
                p_230058_.m_230174_(p_230059_ + direction1.m_122429_(), p_230060_ + direction1.m_122431_(), 0, 2);
                p_230058_.m_230174_(p_230059_ + direction2.m_122429_(), p_230060_ + direction2.m_122431_(), 0, 2);
                p_230058_.m_230174_(p_230059_ + p_230061_.m_122429_() + direction1.m_122429_(), p_230060_ + p_230061_.m_122431_() + direction1.m_122431_(), 0, 2);
                p_230058_.m_230174_(p_230059_ + p_230061_.m_122429_() + direction2.m_122429_(), p_230060_ + p_230061_.m_122431_() + direction2.m_122431_(), 0, 2);
                p_230058_.m_230174_(p_230059_ + p_230061_.m_122429_() * 2, p_230060_ + p_230061_.m_122431_() * 2, 0, 2);
                p_230058_.m_230174_(p_230059_ + direction1.m_122429_() * 2, p_230060_ + direction1.m_122431_() * 2, 0, 2);
                p_230058_.m_230174_(p_230059_ + direction2.m_122429_() * 2, p_230060_ + direction2.m_122431_() * 2, 0, 2);
            }
        }

        private boolean m_230045_(SimpleGrid p_230046_) {
            boolean flag = false;
            for (int i = 0; i < p_230046_.f_230161_; ++i) {
                for (int j = 0; j < p_230046_.f_230160_; ++j) {
                    if (p_230046_.m_230167_(j, i) != 0) continue;
                    int k = 0;
                    k += MansionGrid.m_230047_(p_230046_, j + 1, i) ? 1 : 0;
                    k += MansionGrid.m_230047_(p_230046_, j - 1, i) ? 1 : 0;
                    k += MansionGrid.m_230047_(p_230046_, j, i + 1) ? 1 : 0;
                    if ((k += MansionGrid.m_230047_(p_230046_, j, i - 1) ? 1 : 0) >= 3) {
                        p_230046_.m_230170_(j, i, 2);
                        flag = true;
                        continue;
                    }
                    if (k != 2) continue;
                    int l = 0;
                    l += MansionGrid.m_230047_(p_230046_, j + 1, i + 1) ? 1 : 0;
                    l += MansionGrid.m_230047_(p_230046_, j - 1, i + 1) ? 1 : 0;
                    l += MansionGrid.m_230047_(p_230046_, j + 1, i - 1) ? 1 : 0;
                    if ((l += MansionGrid.m_230047_(p_230046_, j - 1, i - 1) ? 1 : 0) > 1) continue;
                    p_230046_.m_230170_(j, i, 2);
                    flag = true;
                }
            }
            return flag;
        }

        private void m_230066_() {
            ArrayList list = Lists.newArrayList();
            SimpleGrid woodlandmansionpieces$simplegrid = this.f_230039_[1];
            for (int i = 0; i < this.f_230038_.f_230161_; ++i) {
                for (int j = 0; j < this.f_230038_.f_230160_; ++j) {
                    int k = woodlandmansionpieces$simplegrid.m_230167_(j, i);
                    int l = k & 0xF0000;
                    if (l != 131072 || (k & 0x200000) != 0x200000) continue;
                    list.add(new Tuple((Object)j, (Object)i));
                }
            }
            if (list.isEmpty()) {
                this.f_230038_.m_230179_(0, 0, this.f_230038_.f_230160_, this.f_230038_.f_230161_, 5);
            } else {
                Tuple tuple = (Tuple)list.get(this.f_230036_.m_188503_(list.size()));
                int l1 = woodlandmansionpieces$simplegrid.m_230167_((Integer)tuple.m_14418_(), (Integer)tuple.m_14419_());
                woodlandmansionpieces$simplegrid.m_230170_((Integer)tuple.m_14418_(), (Integer)tuple.m_14419_(), l1 | 0x400000);
                Direction direction1 = this.m_230067_(this.f_230037_, (Integer)tuple.m_14418_(), (Integer)tuple.m_14419_(), 1, l1 & 0xFFFF);
                int i2 = (Integer)tuple.m_14418_() + direction1.m_122429_();
                int i1 = (Integer)tuple.m_14419_() + direction1.m_122431_();
                for (int j1 = 0; j1 < this.f_230038_.f_230161_; ++j1) {
                    for (int k1 = 0; k1 < this.f_230038_.f_230160_; ++k1) {
                        if (!MansionGrid.m_230047_(this.f_230037_, k1, j1)) {
                            this.f_230038_.m_230170_(k1, j1, 5);
                            continue;
                        }
                        if (k1 == (Integer)tuple.m_14418_() && j1 == (Integer)tuple.m_14419_()) {
                            this.f_230038_.m_230170_(k1, j1, 3);
                            continue;
                        }
                        if (k1 != i2 || j1 != i1) continue;
                        this.f_230038_.m_230170_(k1, j1, 3);
                        this.f_230039_[2].m_230170_(k1, j1, 0x800000);
                    }
                }
                ArrayList list1 = Lists.newArrayList();
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    if (this.f_230038_.m_230167_(i2 + direction.m_122429_(), i1 + direction.m_122431_()) != 0) continue;
                    list1.add(direction);
                }
                if (list1.isEmpty()) {
                    this.f_230038_.m_230179_(0, 0, this.f_230038_.f_230160_, this.f_230038_.f_230161_, 5);
                    woodlandmansionpieces$simplegrid.m_230170_((Integer)tuple.m_14418_(), (Integer)tuple.m_14419_(), l1);
                } else {
                    Direction direction2 = (Direction)list1.get(this.f_230036_.m_188503_(list1.size()));
                    this.m_230057_(this.f_230038_, i2 + direction2.m_122429_(), i1 + direction2.m_122431_(), direction2, 4);
                    while (this.m_230045_(this.f_230038_)) {
                    }
                }
            }
        }

        private void m_230063_(SimpleGrid p_230064_, SimpleGrid p_230065_) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            for (int i = 0; i < p_230064_.f_230161_; ++i) {
                for (int j = 0; j < p_230064_.f_230160_; ++j) {
                    if (p_230064_.m_230167_(j, i) != 2) continue;
                    objectarraylist.add((Object)new Tuple((Object)j, (Object)i));
                }
            }
            Util.m_214673_(objectarraylist, this.f_230036_);
            int k3 = 10;
            for (Tuple tuple : objectarraylist) {
                int l;
                int k = (Integer)tuple.m_14418_();
                if (p_230065_.m_230167_(k, l = ((Integer)tuple.m_14419_()).intValue()) != 0) continue;
                int i1 = k;
                int j1 = k;
                int k1 = l;
                int l1 = l;
                int i2 = 65536;
                if (p_230065_.m_230167_(k + 1, l) == 0 && p_230065_.m_230167_(k, l + 1) == 0 && p_230065_.m_230167_(k + 1, l + 1) == 0 && p_230064_.m_230167_(k + 1, l) == 2 && p_230064_.m_230167_(k, l + 1) == 2 && p_230064_.m_230167_(k + 1, l + 1) == 2) {
                    j1 = k + 1;
                    l1 = l + 1;
                    i2 = 262144;
                } else if (p_230065_.m_230167_(k - 1, l) == 0 && p_230065_.m_230167_(k, l + 1) == 0 && p_230065_.m_230167_(k - 1, l + 1) == 0 && p_230064_.m_230167_(k - 1, l) == 2 && p_230064_.m_230167_(k, l + 1) == 2 && p_230064_.m_230167_(k - 1, l + 1) == 2) {
                    i1 = k - 1;
                    l1 = l + 1;
                    i2 = 262144;
                } else if (p_230065_.m_230167_(k - 1, l) == 0 && p_230065_.m_230167_(k, l - 1) == 0 && p_230065_.m_230167_(k - 1, l - 1) == 0 && p_230064_.m_230167_(k - 1, l) == 2 && p_230064_.m_230167_(k, l - 1) == 2 && p_230064_.m_230167_(k - 1, l - 1) == 2) {
                    i1 = k - 1;
                    k1 = l - 1;
                    i2 = 262144;
                } else if (p_230065_.m_230167_(k + 1, l) == 0 && p_230064_.m_230167_(k + 1, l) == 2) {
                    j1 = k + 1;
                    i2 = 131072;
                } else if (p_230065_.m_230167_(k, l + 1) == 0 && p_230064_.m_230167_(k, l + 1) == 2) {
                    l1 = l + 1;
                    i2 = 131072;
                } else if (p_230065_.m_230167_(k - 1, l) == 0 && p_230064_.m_230167_(k - 1, l) == 2) {
                    i1 = k - 1;
                    i2 = 131072;
                } else if (p_230065_.m_230167_(k, l - 1) == 0 && p_230064_.m_230167_(k, l - 1) == 2) {
                    k1 = l - 1;
                    i2 = 131072;
                }
                int j2 = this.f_230036_.m_188499_() ? i1 : j1;
                int k2 = this.f_230036_.m_188499_() ? k1 : l1;
                int l2 = 0x200000;
                if (!p_230064_.m_230185_(j2, k2, 1)) {
                    j2 = j2 == i1 ? j1 : i1;
                    int n = k2 = k2 == k1 ? l1 : k1;
                    if (!p_230064_.m_230185_(j2, k2, 1)) {
                        int n2 = k2 = k2 == k1 ? l1 : k1;
                        if (!p_230064_.m_230185_(j2, k2, 1)) {
                            j2 = j2 == i1 ? j1 : i1;
                            int n3 = k2 = k2 == k1 ? l1 : k1;
                            if (!p_230064_.m_230185_(j2, k2, 1)) {
                                l2 = 0;
                                j2 = i1;
                                k2 = k1;
                            }
                        }
                    }
                }
                for (int i3 = k1; i3 <= l1; ++i3) {
                    for (int j3 = i1; j3 <= j1; ++j3) {
                        if (j3 == j2 && i3 == k2) {
                            p_230065_.m_230170_(j3, i3, 0x100000 | l2 | i2 | k3);
                            continue;
                        }
                        p_230065_.m_230170_(j3, i3, i2 | k3);
                    }
                }
                ++k3;
            }
        }

        public void m_230044_() {
            for (int i = 0; i < 2; ++i) {
                SimpleGrid woodlandmansionpieces$simplegrid = i == 0 ? this.f_230037_ : this.f_230038_;
                for (int j = 0; j < woodlandmansionpieces$simplegrid.f_230161_; ++j) {
                    for (int k = 0; k < woodlandmansionpieces$simplegrid.f_230160_; ++k) {
                        int l = woodlandmansionpieces$simplegrid.m_230167_(k, j);
                        if (l == 1) {
                            System.out.print("+");
                            continue;
                        }
                        if (l == 4) {
                            System.out.print("x");
                            continue;
                        }
                        if (l == 2) {
                            System.out.print("X");
                            continue;
                        }
                        if (l == 3) {
                            System.out.print("O");
                            continue;
                        }
                        if (l == 5) {
                            System.out.print("#");
                            continue;
                        }
                        System.out.print(" ");
                    }
                    System.out.println("");
                }
                System.out.println("");
            }
        }
    }

    static class MansionPiecePlacer {
        private final StructureTemplateManager f_230073_;
        private final RandomSource f_230074_;
        private int f_230075_;
        private int f_230076_;

        public MansionPiecePlacer(StructureTemplateManager p_230078_, RandomSource p_230079_) {
            this.f_230073_ = p_230078_;
            this.f_230074_ = p_230079_;
        }

        public void m_230080_(BlockPos p_230081_, Rotation p_230082_, List<WoodlandMansionPiece> p_230083_, MansionGrid p_230084_) {
            PlacementData woodlandmansionpieces$placementdata = new PlacementData();
            woodlandmansionpieces$placementdata.f_230139_ = p_230081_;
            woodlandmansionpieces$placementdata.f_230138_ = p_230082_;
            woodlandmansionpieces$placementdata.f_230140_ = "wall_flat";
            PlacementData woodlandmansionpieces$placementdata1 = new PlacementData();
            this.m_230085_(p_230083_, woodlandmansionpieces$placementdata);
            woodlandmansionpieces$placementdata1.f_230139_ = woodlandmansionpieces$placementdata.f_230139_.m_6630_(8);
            woodlandmansionpieces$placementdata1.f_230138_ = woodlandmansionpieces$placementdata.f_230138_;
            woodlandmansionpieces$placementdata1.f_230140_ = "wall_window";
            if (!p_230083_.isEmpty()) {
                // empty if block
            }
            SimpleGrid woodlandmansionpieces$simplegrid = p_230084_.f_230037_;
            SimpleGrid woodlandmansionpieces$simplegrid1 = p_230084_.f_230038_;
            this.f_230075_ = p_230084_.f_230040_ + 1;
            this.f_230076_ = p_230084_.f_230041_ + 1;
            int i = p_230084_.f_230040_ + 1;
            int j = p_230084_.f_230041_;
            this.m_230088_(p_230083_, woodlandmansionpieces$placementdata, woodlandmansionpieces$simplegrid, Direction.SOUTH, this.f_230075_, this.f_230076_, i, j);
            this.m_230088_(p_230083_, woodlandmansionpieces$placementdata1, woodlandmansionpieces$simplegrid, Direction.SOUTH, this.f_230075_, this.f_230076_, i, j);
            PlacementData woodlandmansionpieces$placementdata2 = new PlacementData();
            woodlandmansionpieces$placementdata2.f_230139_ = woodlandmansionpieces$placementdata.f_230139_.m_6630_(19);
            woodlandmansionpieces$placementdata2.f_230138_ = woodlandmansionpieces$placementdata.f_230138_;
            woodlandmansionpieces$placementdata2.f_230140_ = "wall_window";
            boolean flag = false;
            for (int k = 0; k < woodlandmansionpieces$simplegrid1.f_230161_ && !flag; ++k) {
                for (int l = woodlandmansionpieces$simplegrid1.f_230160_ - 1; l >= 0 && !flag; --l) {
                    if (!MansionGrid.m_230047_(woodlandmansionpieces$simplegrid1, l, k)) continue;
                    woodlandmansionpieces$placementdata2.f_230139_ = woodlandmansionpieces$placementdata2.f_230139_.m_5484_(p_230082_.m_55954_(Direction.SOUTH), 8 + (k - this.f_230076_) * 8);
                    woodlandmansionpieces$placementdata2.f_230139_ = woodlandmansionpieces$placementdata2.f_230139_.m_5484_(p_230082_.m_55954_(Direction.EAST), (l - this.f_230075_) * 8);
                    this.m_230129_(p_230083_, woodlandmansionpieces$placementdata2);
                    this.m_230088_(p_230083_, woodlandmansionpieces$placementdata2, woodlandmansionpieces$simplegrid1, Direction.SOUTH, l, k, l, k);
                    flag = true;
                }
            }
            this.m_230102_(p_230083_, p_230081_.m_6630_(16), p_230082_, woodlandmansionpieces$simplegrid, woodlandmansionpieces$simplegrid1);
            this.m_230102_(p_230083_, p_230081_.m_6630_(27), p_230082_, woodlandmansionpieces$simplegrid1, null);
            if (!p_230083_.isEmpty()) {
                // empty if block
            }
            FloorRoomCollection[] awoodlandmansionpieces$floorroomcollection = new FloorRoomCollection[]{new FirstFloorRoomCollection(), new SecondFloorRoomCollection(), new ThirdFloorRoomCollection()};
            for (int l2 = 0; l2 < 3; ++l2) {
                BlockPos blockpos = p_230081_.m_6630_(8 * l2 + (l2 == 2 ? 3 : 0));
                SimpleGrid woodlandmansionpieces$simplegrid2 = p_230084_.f_230039_[l2];
                SimpleGrid woodlandmansionpieces$simplegrid3 = l2 == 2 ? woodlandmansionpieces$simplegrid1 : woodlandmansionpieces$simplegrid;
                String s = l2 == 0 ? "carpet_south_1" : "carpet_south_2";
                String s1 = l2 == 0 ? "carpet_west_1" : "carpet_west_2";
                for (int i1 = 0; i1 < woodlandmansionpieces$simplegrid3.f_230161_; ++i1) {
                    for (int j1 = 0; j1 < woodlandmansionpieces$simplegrid3.f_230160_; ++j1) {
                        if (woodlandmansionpieces$simplegrid3.m_230167_(j1, i1) != 1) continue;
                        BlockPos blockpos1 = blockpos.m_5484_(p_230082_.m_55954_(Direction.SOUTH), 8 + (i1 - this.f_230076_) * 8);
                        blockpos1 = blockpos1.m_5484_(p_230082_.m_55954_(Direction.EAST), (j1 - this.f_230075_) * 8);
                        p_230083_.add(new WoodlandMansionPiece(this.f_230073_, "corridor_floor", blockpos1, p_230082_));
                        if (woodlandmansionpieces$simplegrid3.m_230167_(j1, i1 - 1) == 1 || (woodlandmansionpieces$simplegrid2.m_230167_(j1, i1 - 1) & 0x800000) == 0x800000) {
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, "carpet_north", blockpos1.m_5484_(p_230082_.m_55954_(Direction.EAST), 1).m_7494_(), p_230082_));
                        }
                        if (woodlandmansionpieces$simplegrid3.m_230167_(j1 + 1, i1) == 1 || (woodlandmansionpieces$simplegrid2.m_230167_(j1 + 1, i1) & 0x800000) == 0x800000) {
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, "carpet_east", blockpos1.m_5484_(p_230082_.m_55954_(Direction.SOUTH), 1).m_5484_(p_230082_.m_55954_(Direction.EAST), 5).m_7494_(), p_230082_));
                        }
                        if (woodlandmansionpieces$simplegrid3.m_230167_(j1, i1 + 1) == 1 || (woodlandmansionpieces$simplegrid2.m_230167_(j1, i1 + 1) & 0x800000) == 0x800000) {
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, s, blockpos1.m_5484_(p_230082_.m_55954_(Direction.SOUTH), 5).m_5484_(p_230082_.m_55954_(Direction.WEST), 1), p_230082_));
                        }
                        if (woodlandmansionpieces$simplegrid3.m_230167_(j1 - 1, i1) != 1 && (woodlandmansionpieces$simplegrid2.m_230167_(j1 - 1, i1) & 0x800000) != 0x800000) continue;
                        p_230083_.add(new WoodlandMansionPiece(this.f_230073_, s1, blockpos1.m_5484_(p_230082_.m_55954_(Direction.WEST), 1).m_5484_(p_230082_.m_55954_(Direction.NORTH), 1), p_230082_));
                    }
                }
                String s2 = l2 == 0 ? "indoors_wall_1" : "indoors_wall_2";
                String s3 = l2 == 0 ? "indoors_door_1" : "indoors_door_2";
                ArrayList list = Lists.newArrayList();
                for (int k1 = 0; k1 < woodlandmansionpieces$simplegrid3.f_230161_; ++k1) {
                    for (int l1 = 0; l1 < woodlandmansionpieces$simplegrid3.f_230160_; ++l1) {
                        boolean flag1;
                        boolean bl = flag1 = l2 == 2 && woodlandmansionpieces$simplegrid3.m_230167_(l1, k1) == 3;
                        if (woodlandmansionpieces$simplegrid3.m_230167_(l1, k1) != 2 && !flag1) continue;
                        int i2 = woodlandmansionpieces$simplegrid2.m_230167_(l1, k1);
                        int j2 = i2 & 0xF0000;
                        int k2 = i2 & 0xFFFF;
                        flag1 = flag1 && (i2 & 0x800000) == 0x800000;
                        list.clear();
                        if ((i2 & 0x200000) == 0x200000) {
                            for (Direction direction : Direction.Plane.HORIZONTAL) {
                                if (woodlandmansionpieces$simplegrid3.m_230167_(l1 + direction.m_122429_(), k1 + direction.m_122431_()) != 1) continue;
                                list.add(direction);
                            }
                        }
                        Direction direction1 = null;
                        if (!list.isEmpty()) {
                            direction1 = (Direction)list.get(this.f_230074_.m_188503_(list.size()));
                        } else if ((i2 & 0x100000) == 0x100000) {
                            direction1 = Direction.UP;
                        }
                        BlockPos blockpos3 = blockpos.m_5484_(p_230082_.m_55954_(Direction.SOUTH), 8 + (k1 - this.f_230076_) * 8);
                        blockpos3 = blockpos3.m_5484_(p_230082_.m_55954_(Direction.EAST), -1 + (l1 - this.f_230075_) * 8);
                        if (MansionGrid.m_230047_(woodlandmansionpieces$simplegrid3, l1 - 1, k1) && !p_230084_.m_230051_(woodlandmansionpieces$simplegrid3, l1 - 1, k1, l2, k2)) {
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, direction1 == Direction.WEST ? s3 : s2, blockpos3, p_230082_));
                        }
                        if (woodlandmansionpieces$simplegrid3.m_230167_(l1 + 1, k1) == 1 && !flag1) {
                            BlockPos blockpos2 = blockpos3.m_5484_(p_230082_.m_55954_(Direction.EAST), 8);
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, direction1 == Direction.EAST ? s3 : s2, blockpos2, p_230082_));
                        }
                        if (MansionGrid.m_230047_(woodlandmansionpieces$simplegrid3, l1, k1 + 1) && !p_230084_.m_230051_(woodlandmansionpieces$simplegrid3, l1, k1 + 1, l2, k2)) {
                            BlockPos blockpos4 = blockpos3.m_5484_(p_230082_.m_55954_(Direction.SOUTH), 7);
                            blockpos4 = blockpos4.m_5484_(p_230082_.m_55954_(Direction.EAST), 7);
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, direction1 == Direction.SOUTH ? s3 : s2, blockpos4, p_230082_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (woodlandmansionpieces$simplegrid3.m_230167_(l1, k1 - 1) == 1 && !flag1) {
                            BlockPos blockpos5 = blockpos3.m_5484_(p_230082_.m_55954_(Direction.NORTH), 1);
                            blockpos5 = blockpos5.m_5484_(p_230082_.m_55954_(Direction.EAST), 7);
                            p_230083_.add(new WoodlandMansionPiece(this.f_230073_, direction1 == Direction.NORTH ? s3 : s2, blockpos5, p_230082_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (j2 == 65536) {
                            this.m_230108_(p_230083_, blockpos3, p_230082_, direction1, awoodlandmansionpieces$floorroomcollection[l2]);
                            continue;
                        }
                        if (j2 == 131072 && direction1 != null) {
                            Direction direction3 = p_230084_.m_230067_(woodlandmansionpieces$simplegrid3, l1, k1, l2, k2);
                            boolean flag2 = (i2 & 0x400000) == 0x400000;
                            this.m_230121_(p_230083_, blockpos3, p_230082_, direction3, direction1, awoodlandmansionpieces$floorroomcollection[l2], flag2);
                            continue;
                        }
                        if (j2 == 262144 && direction1 != null && direction1 != Direction.UP) {
                            Direction direction2 = direction1.m_122427_();
                            if (!p_230084_.m_230051_(woodlandmansionpieces$simplegrid3, l1 + direction2.m_122429_(), k1 + direction2.m_122431_(), l2, k2)) {
                                direction2 = direction2.m_122424_();
                            }
                            this.m_230114_(p_230083_, blockpos3, p_230082_, direction2, direction1, awoodlandmansionpieces$floorroomcollection[l2]);
                            continue;
                        }
                        if (j2 != 262144 || direction1 != Direction.UP) continue;
                        this.m_230097_(p_230083_, blockpos3, p_230082_, awoodlandmansionpieces$floorroomcollection[l2]);
                    }
                }
            }
        }

        private void m_230088_(List<WoodlandMansionPiece> p_230089_, PlacementData p_230090_, SimpleGrid p_230091_, Direction p_230092_, int p_230093_, int p_230094_, int p_230095_, int p_230096_) {
            int i = p_230093_;
            int j = p_230094_;
            Direction direction = p_230092_;
            do {
                if (!MansionGrid.m_230047_(p_230091_, i + p_230092_.m_122429_(), j + p_230092_.m_122431_())) {
                    this.m_230132_(p_230089_, p_230090_);
                    p_230092_ = p_230092_.m_122427_();
                    if (i == p_230095_ && j == p_230096_ && direction == p_230092_) continue;
                    this.m_230129_(p_230089_, p_230090_);
                    continue;
                }
                if (MansionGrid.m_230047_(p_230091_, i + p_230092_.m_122429_(), j + p_230092_.m_122431_()) && MansionGrid.m_230047_(p_230091_, i + p_230092_.m_122429_() + p_230092_.m_122428_().m_122429_(), j + p_230092_.m_122431_() + p_230092_.m_122428_().m_122431_())) {
                    this.m_230135_(p_230089_, p_230090_);
                    i += p_230092_.m_122429_();
                    j += p_230092_.m_122431_();
                    p_230092_ = p_230092_.m_122428_();
                    continue;
                }
                if ((i += p_230092_.m_122429_()) == p_230095_ && (j += p_230092_.m_122431_()) == p_230096_ && direction == p_230092_) continue;
                this.m_230129_(p_230089_, p_230090_);
            } while (i != p_230095_ || j != p_230096_ || direction != p_230092_);
        }

        private void m_230102_(List<WoodlandMansionPiece> p_230103_, BlockPos p_230104_, Rotation p_230105_, SimpleGrid p_230106_, @Nullable SimpleGrid p_230107_) {
            for (int i = 0; i < p_230106_.f_230161_; ++i) {
                for (int j = 0; j < p_230106_.f_230160_; ++j) {
                    boolean flag;
                    BlockPos $$27 = p_230104_.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 8 + (i - this.f_230076_) * 8);
                    $$27 = $$27.m_5484_(p_230105_.m_55954_(Direction.EAST), (j - this.f_230075_) * 8);
                    boolean bl = flag = p_230107_ != null && MansionGrid.m_230047_(p_230107_, j, i);
                    if (!MansionGrid.m_230047_(p_230106_, j, i) || flag) continue;
                    p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof", $$27.m_6630_(3), p_230105_));
                    if (!MansionGrid.m_230047_(p_230106_, j + 1, i)) {
                        BlockPos blockpos1 = $$27.m_5484_(p_230105_.m_55954_(Direction.EAST), 6);
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_front", blockpos1, p_230105_));
                    }
                    if (!MansionGrid.m_230047_(p_230106_, j - 1, i)) {
                        BlockPos blockpos5 = $$27.m_5484_(p_230105_.m_55954_(Direction.EAST), 0);
                        blockpos5 = blockpos5.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 7);
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_front", blockpos5, p_230105_.m_55952_(Rotation.CLOCKWISE_180)));
                    }
                    if (!MansionGrid.m_230047_(p_230106_, j, i - 1)) {
                        BlockPos blockpos6 = $$27.m_5484_(p_230105_.m_55954_(Direction.WEST), 1);
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_front", blockpos6, p_230105_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (MansionGrid.m_230047_(p_230106_, j, i + 1)) continue;
                    BlockPos blockpos7 = $$27.m_5484_(p_230105_.m_55954_(Direction.EAST), 6);
                    blockpos7 = blockpos7.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 6);
                    p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_front", blockpos7, p_230105_.m_55952_(Rotation.CLOCKWISE_90)));
                }
            }
            if (p_230107_ != null) {
                for (int k = 0; k < p_230106_.f_230161_; ++k) {
                    for (int i1 = 0; i1 < p_230106_.f_230160_; ++i1) {
                        BlockPos blockpos3 = p_230104_.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 8 + (k - this.f_230076_) * 8);
                        blockpos3 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.EAST), (i1 - this.f_230075_) * 8);
                        boolean flag1 = MansionGrid.m_230047_(p_230107_, i1, k);
                        if (!MansionGrid.m_230047_(p_230106_, i1, k) || !flag1) continue;
                        if (!MansionGrid.m_230047_(p_230106_, i1 + 1, k)) {
                            BlockPos blockpos8 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.EAST), 7);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall", blockpos8, p_230105_));
                        }
                        if (!MansionGrid.m_230047_(p_230106_, i1 - 1, k)) {
                            BlockPos blockpos9 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.WEST), 1);
                            blockpos9 = blockpos9.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 6);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall", blockpos9, p_230105_.m_55952_(Rotation.CLOCKWISE_180)));
                        }
                        if (!MansionGrid.m_230047_(p_230106_, i1, k - 1)) {
                            BlockPos blockpos10 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.WEST), 0);
                            blockpos10 = blockpos10.m_5484_(p_230105_.m_55954_(Direction.NORTH), 1);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall", blockpos10, p_230105_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (!MansionGrid.m_230047_(p_230106_, i1, k + 1)) {
                            BlockPos blockpos11 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.EAST), 6);
                            blockpos11 = blockpos11.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 7);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall", blockpos11, p_230105_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                        if (!MansionGrid.m_230047_(p_230106_, i1 + 1, k)) {
                            if (!MansionGrid.m_230047_(p_230106_, i1, k - 1)) {
                                BlockPos blockpos12 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.EAST), 7);
                                blockpos12 = blockpos12.m_5484_(p_230105_.m_55954_(Direction.NORTH), 2);
                                p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall_corner", blockpos12, p_230105_));
                            }
                            if (!MansionGrid.m_230047_(p_230106_, i1, k + 1)) {
                                BlockPos blockpos13 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.EAST), 8);
                                blockpos13 = blockpos13.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 7);
                                p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall_corner", blockpos13, p_230105_.m_55952_(Rotation.CLOCKWISE_90)));
                            }
                        }
                        if (MansionGrid.m_230047_(p_230106_, i1 - 1, k)) continue;
                        if (!MansionGrid.m_230047_(p_230106_, i1, k - 1)) {
                            BlockPos blockpos14 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.WEST), 2);
                            blockpos14 = blockpos14.m_5484_(p_230105_.m_55954_(Direction.NORTH), 1);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall_corner", blockpos14, p_230105_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        }
                        if (MansionGrid.m_230047_(p_230106_, i1, k + 1)) continue;
                        BlockPos blockpos15 = blockpos3.m_5484_(p_230105_.m_55954_(Direction.WEST), 1);
                        blockpos15 = blockpos15.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 8);
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "small_wall_corner", blockpos15, p_230105_.m_55952_(Rotation.CLOCKWISE_180)));
                    }
                }
            }
            for (int l = 0; l < p_230106_.f_230161_; ++l) {
                for (int j1 = 0; j1 < p_230106_.f_230160_; ++j1) {
                    boolean flag2;
                    BlockPos blockpos4 = p_230104_.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 8 + (l - this.f_230076_) * 8);
                    blockpos4 = blockpos4.m_5484_(p_230105_.m_55954_(Direction.EAST), (j1 - this.f_230075_) * 8);
                    boolean bl = flag2 = p_230107_ != null && MansionGrid.m_230047_(p_230107_, j1, l);
                    if (!MansionGrid.m_230047_(p_230106_, j1, l) || flag2) continue;
                    if (!MansionGrid.m_230047_(p_230106_, j1 + 1, l)) {
                        BlockPos blockpos16 = blockpos4.m_5484_(p_230105_.m_55954_(Direction.EAST), 6);
                        if (!MansionGrid.m_230047_(p_230106_, j1, l + 1)) {
                            BlockPos blockpos2 = blockpos16.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 6);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_corner", blockpos2, p_230105_));
                        } else if (MansionGrid.m_230047_(p_230106_, j1 + 1, l + 1)) {
                            BlockPos blockpos18 = blockpos16.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 5);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_inner_corner", blockpos18, p_230105_));
                        }
                        if (!MansionGrid.m_230047_(p_230106_, j1, l - 1)) {
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_corner", blockpos16, p_230105_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                        } else if (MansionGrid.m_230047_(p_230106_, j1 + 1, l - 1)) {
                            BlockPos blockpos19 = blockpos4.m_5484_(p_230105_.m_55954_(Direction.EAST), 9);
                            blockpos19 = blockpos19.m_5484_(p_230105_.m_55954_(Direction.NORTH), 2);
                            p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_inner_corner", blockpos19, p_230105_.m_55952_(Rotation.CLOCKWISE_90)));
                        }
                    }
                    if (MansionGrid.m_230047_(p_230106_, j1 - 1, l)) continue;
                    BlockPos blockpos17 = blockpos4.m_5484_(p_230105_.m_55954_(Direction.EAST), 0);
                    blockpos17 = blockpos17.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 0);
                    if (!MansionGrid.m_230047_(p_230106_, j1, l + 1)) {
                        BlockPos blockpos20 = blockpos17.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 6);
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_corner", blockpos20, p_230105_.m_55952_(Rotation.CLOCKWISE_90)));
                    } else if (MansionGrid.m_230047_(p_230106_, j1 - 1, l + 1)) {
                        BlockPos blockpos21 = blockpos17.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 8);
                        blockpos21 = blockpos21.m_5484_(p_230105_.m_55954_(Direction.WEST), 3);
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_inner_corner", blockpos21, p_230105_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
                    }
                    if (!MansionGrid.m_230047_(p_230106_, j1, l - 1)) {
                        p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_corner", blockpos17, p_230105_.m_55952_(Rotation.CLOCKWISE_180)));
                        continue;
                    }
                    if (!MansionGrid.m_230047_(p_230106_, j1 - 1, l - 1)) continue;
                    BlockPos blockpos22 = blockpos17.m_5484_(p_230105_.m_55954_(Direction.SOUTH), 1);
                    p_230103_.add(new WoodlandMansionPiece(this.f_230073_, "roof_inner_corner", blockpos22, p_230105_.m_55952_(Rotation.CLOCKWISE_180)));
                }
            }
        }

        private void m_230085_(List<WoodlandMansionPiece> p_230086_, PlacementData p_230087_) {
            Direction direction = p_230087_.f_230138_.m_55954_(Direction.WEST);
            p_230086_.add(new WoodlandMansionPiece(this.f_230073_, "entrance", p_230087_.f_230139_.m_5484_(direction, 9), p_230087_.f_230138_));
            p_230087_.f_230139_ = p_230087_.f_230139_.m_5484_(p_230087_.f_230138_.m_55954_(Direction.SOUTH), 16);
        }

        private void m_230129_(List<WoodlandMansionPiece> p_230130_, PlacementData p_230131_) {
            p_230130_.add(new WoodlandMansionPiece(this.f_230073_, p_230131_.f_230140_, p_230131_.f_230139_.m_5484_(p_230131_.f_230138_.m_55954_(Direction.EAST), 7), p_230131_.f_230138_));
            p_230131_.f_230139_ = p_230131_.f_230139_.m_5484_(p_230131_.f_230138_.m_55954_(Direction.SOUTH), 8);
        }

        private void m_230132_(List<WoodlandMansionPiece> p_230133_, PlacementData p_230134_) {
            p_230134_.f_230139_ = p_230134_.f_230139_.m_5484_(p_230134_.f_230138_.m_55954_(Direction.SOUTH), -1);
            p_230133_.add(new WoodlandMansionPiece(this.f_230073_, "wall_corner", p_230134_.f_230139_, p_230134_.f_230138_));
            p_230134_.f_230139_ = p_230134_.f_230139_.m_5484_(p_230134_.f_230138_.m_55954_(Direction.SOUTH), -7);
            p_230134_.f_230139_ = p_230134_.f_230139_.m_5484_(p_230134_.f_230138_.m_55954_(Direction.WEST), -6);
            p_230134_.f_230138_ = p_230134_.f_230138_.m_55952_(Rotation.CLOCKWISE_90);
        }

        private void m_230135_(List<WoodlandMansionPiece> p_230136_, PlacementData p_230137_) {
            p_230137_.f_230139_ = p_230137_.f_230139_.m_5484_(p_230137_.f_230138_.m_55954_(Direction.SOUTH), 6);
            p_230137_.f_230139_ = p_230137_.f_230139_.m_5484_(p_230137_.f_230138_.m_55954_(Direction.EAST), 8);
            p_230137_.f_230138_ = p_230137_.f_230138_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
        }

        private void m_230108_(List<WoodlandMansionPiece> p_230109_, BlockPos p_230110_, Rotation p_230111_, Direction p_230112_, FloorRoomCollection p_230113_) {
            Rotation rotation = Rotation.NONE;
            String s = p_230113_.m_214126_(this.f_230074_);
            if (p_230112_ != Direction.EAST) {
                if (p_230112_ == Direction.NORTH) {
                    rotation = rotation.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                } else if (p_230112_ == Direction.WEST) {
                    rotation = rotation.m_55952_(Rotation.CLOCKWISE_180);
                } else if (p_230112_ == Direction.SOUTH) {
                    rotation = rotation.m_55952_(Rotation.CLOCKWISE_90);
                } else {
                    s = p_230113_.m_214127_(this.f_230074_);
                }
            }
            BlockPos blockpos = StructureTemplate.m_74587_(new BlockPos(1, 0, 0), Mirror.NONE, rotation, 7, 7);
            rotation = rotation.m_55952_(p_230111_);
            blockpos = blockpos.m_7954_(p_230111_);
            BlockPos blockpos1 = p_230110_.m_7918_(blockpos.m_123341_(), 0, blockpos.m_123343_());
            p_230109_.add(new WoodlandMansionPiece(this.f_230073_, s, blockpos1, rotation));
        }

        private void m_230121_(List<WoodlandMansionPiece> p_230122_, BlockPos p_230123_, Rotation p_230124_, Direction p_230125_, Direction p_230126_, FloorRoomCollection p_230127_, boolean p_230128_) {
            if (p_230126_ == Direction.EAST && p_230125_ == Direction.SOUTH) {
                BlockPos blockpos13 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 1);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos13, p_230124_));
            } else if (p_230126_ == Direction.EAST && p_230125_ == Direction.NORTH) {
                BlockPos blockpos12 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 1);
                blockpos12 = blockpos12.m_5484_(p_230124_.m_55954_(Direction.SOUTH), 6);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos12, p_230124_, Mirror.LEFT_RIGHT));
            } else if (p_230126_ == Direction.WEST && p_230125_ == Direction.NORTH) {
                BlockPos blockpos11 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 7);
                blockpos11 = blockpos11.m_5484_(p_230124_.m_55954_(Direction.SOUTH), 6);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos11, p_230124_.m_55952_(Rotation.CLOCKWISE_180)));
            } else if (p_230126_ == Direction.WEST && p_230125_ == Direction.SOUTH) {
                BlockPos blockpos10 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 7);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos10, p_230124_, Mirror.FRONT_BACK));
            } else if (p_230126_ == Direction.SOUTH && p_230125_ == Direction.EAST) {
                BlockPos blockpos9 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 1);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos9, p_230124_.m_55952_(Rotation.CLOCKWISE_90), Mirror.LEFT_RIGHT));
            } else if (p_230126_ == Direction.SOUTH && p_230125_ == Direction.WEST) {
                BlockPos blockpos8 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 7);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos8, p_230124_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_230126_ == Direction.NORTH && p_230125_ == Direction.WEST) {
                BlockPos blockpos7 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 7);
                blockpos7 = blockpos7.m_5484_(p_230124_.m_55954_(Direction.SOUTH), 6);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos7, p_230124_.m_55952_(Rotation.CLOCKWISE_90), Mirror.FRONT_BACK));
            } else if (p_230126_ == Direction.NORTH && p_230125_ == Direction.EAST) {
                BlockPos blockpos6 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 1);
                blockpos6 = blockpos6.m_5484_(p_230124_.m_55954_(Direction.SOUTH), 6);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213986_(this.f_230074_, p_230128_), blockpos6, p_230124_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_230126_ == Direction.SOUTH && p_230125_ == Direction.NORTH) {
                BlockPos blockpos5 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 1);
                blockpos5 = blockpos5.m_5484_(p_230124_.m_55954_(Direction.NORTH), 8);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213985_(this.f_230074_, p_230128_), blockpos5, p_230124_));
            } else if (p_230126_ == Direction.NORTH && p_230125_ == Direction.SOUTH) {
                BlockPos blockpos4 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 7);
                blockpos4 = blockpos4.m_5484_(p_230124_.m_55954_(Direction.SOUTH), 14);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213985_(this.f_230074_, p_230128_), blockpos4, p_230124_.m_55952_(Rotation.CLOCKWISE_180)));
            } else if (p_230126_ == Direction.WEST && p_230125_ == Direction.EAST) {
                BlockPos blockpos3 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 15);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213985_(this.f_230074_, p_230128_), blockpos3, p_230124_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_230126_ == Direction.EAST && p_230125_ == Direction.WEST) {
                BlockPos blockpos2 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.WEST), 7);
                blockpos2 = blockpos2.m_5484_(p_230124_.m_55954_(Direction.SOUTH), 6);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_213985_(this.f_230074_, p_230128_), blockpos2, p_230124_.m_55952_(Rotation.COUNTERCLOCKWISE_90)));
            } else if (p_230126_ == Direction.UP && p_230125_ == Direction.EAST) {
                BlockPos blockpos1 = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 15);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_214128_(this.f_230074_), blockpos1, p_230124_.m_55952_(Rotation.CLOCKWISE_90)));
            } else if (p_230126_ == Direction.UP && p_230125_ == Direction.SOUTH) {
                BlockPos blockpos = p_230123_.m_5484_(p_230124_.m_55954_(Direction.EAST), 1);
                blockpos = blockpos.m_5484_(p_230124_.m_55954_(Direction.NORTH), 0);
                p_230122_.add(new WoodlandMansionPiece(this.f_230073_, p_230127_.m_214128_(this.f_230074_), blockpos, p_230124_));
            }
        }

        private void m_230114_(List<WoodlandMansionPiece> p_230115_, BlockPos p_230116_, Rotation p_230117_, Direction p_230118_, Direction p_230119_, FloorRoomCollection p_230120_) {
            int i = 0;
            int j = 0;
            Rotation rotation = p_230117_;
            Mirror mirror = Mirror.NONE;
            if (p_230119_ == Direction.EAST && p_230118_ == Direction.SOUTH) {
                i = -7;
            } else if (p_230119_ == Direction.EAST && p_230118_ == Direction.NORTH) {
                i = -7;
                j = 6;
                mirror = Mirror.LEFT_RIGHT;
            } else if (p_230119_ == Direction.NORTH && p_230118_ == Direction.EAST) {
                i = 1;
                j = 14;
                rotation = p_230117_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
            } else if (p_230119_ == Direction.NORTH && p_230118_ == Direction.WEST) {
                i = 7;
                j = 14;
                rotation = p_230117_.m_55952_(Rotation.COUNTERCLOCKWISE_90);
                mirror = Mirror.LEFT_RIGHT;
            } else if (p_230119_ == Direction.SOUTH && p_230118_ == Direction.WEST) {
                i = 7;
                j = -8;
                rotation = p_230117_.m_55952_(Rotation.CLOCKWISE_90);
            } else if (p_230119_ == Direction.SOUTH && p_230118_ == Direction.EAST) {
                i = 1;
                j = -8;
                rotation = p_230117_.m_55952_(Rotation.CLOCKWISE_90);
                mirror = Mirror.LEFT_RIGHT;
            } else if (p_230119_ == Direction.WEST && p_230118_ == Direction.NORTH) {
                i = 15;
                j = 6;
                rotation = p_230117_.m_55952_(Rotation.CLOCKWISE_180);
            } else if (p_230119_ == Direction.WEST && p_230118_ == Direction.SOUTH) {
                i = 15;
                mirror = Mirror.FRONT_BACK;
            }
            BlockPos blockpos = p_230116_.m_5484_(p_230117_.m_55954_(Direction.EAST), i);
            blockpos = blockpos.m_5484_(p_230117_.m_55954_(Direction.SOUTH), j);
            p_230115_.add(new WoodlandMansionPiece(this.f_230073_, p_230120_.m_214124_(this.f_230074_), blockpos, rotation, mirror));
        }

        private void m_230097_(List<WoodlandMansionPiece> p_230098_, BlockPos p_230099_, Rotation p_230100_, FloorRoomCollection p_230101_) {
            BlockPos blockpos = p_230099_.m_5484_(p_230100_.m_55954_(Direction.EAST), 1);
            p_230098_.add(new WoodlandMansionPiece(this.f_230073_, p_230101_.m_214125_(this.f_230074_), blockpos, p_230100_, Mirror.NONE));
        }
    }

    public static class WoodlandMansionPiece
    extends TemplateStructurePiece {
        public WoodlandMansionPiece(StructureTemplateManager p_230191_, String p_230192_, BlockPos p_230193_, Rotation p_230194_) {
            this(p_230191_, p_230192_, p_230193_, p_230194_, Mirror.NONE);
        }

        public WoodlandMansionPiece(StructureTemplateManager p_230196_, String p_230197_, BlockPos p_230198_, Rotation p_230199_, Mirror p_230200_) {
            super(StructurePieceType.f_210120_, 0, p_230196_, WoodlandMansionPiece.m_230210_(p_230197_), p_230197_, WoodlandMansionPiece.m_230204_(p_230200_, p_230199_), p_230198_);
        }

        public WoodlandMansionPiece(StructureTemplateManager p_230202_, CompoundTag p_230203_) {
            super(StructurePieceType.f_210120_, p_230203_, p_230202_, p_230220_ -> WoodlandMansionPiece.m_230204_(Mirror.valueOf((String)p_230203_.m_128461_("Mi")), Rotation.valueOf((String)p_230203_.m_128461_("Rot"))));
        }

        protected ResourceLocation m_142415_() {
            return WoodlandMansionPiece.m_230210_(this.f_163658_);
        }

        private static ResourceLocation m_230210_(String p_230211_) {
            return new ResourceLocation("woodland_mansion/" + p_230211_);
        }

        private static StructurePlaceSettings m_230204_(Mirror p_230205_, Rotation p_230206_) {
            return new StructurePlaceSettings().m_74392_(true).m_74379_(p_230206_).m_74377_(p_230205_).m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74046_);
        }

        protected void m_183620_(StructurePieceSerializationContext p_230208_, CompoundTag p_230209_) {
            super.m_183620_(p_230208_, p_230209_);
            p_230209_.m_128359_("Rot", this.f_73657_.m_74404_().name());
            p_230209_.m_128359_("Mi", this.f_73657_.m_74401_().name());
        }

        protected void m_213704_(String p_230213_, BlockPos p_230214_, ServerLevelAccessor p_230215_, RandomSource p_230216_, BoundingBox p_230217_) {
            if (p_230213_.startsWith("Chest")) {
                Rotation rotation = this.f_73657_.m_74404_();
                BlockState blockstate = Blocks.f_50087_.m_49966_();
                if ("ChestWest".equals(p_230213_)) {
                    blockstate = (BlockState)((Object)blockstate.m_61124_((Property)ChestBlock.f_51478_, (Comparable)rotation.m_55954_(Direction.WEST)));
                } else if ("ChestEast".equals(p_230213_)) {
                    blockstate = (BlockState)((Object)blockstate.m_61124_((Property)ChestBlock.f_51478_, (Comparable)rotation.m_55954_(Direction.EAST)));
                } else if ("ChestSouth".equals(p_230213_)) {
                    blockstate = (BlockState)((Object)blockstate.m_61124_((Property)ChestBlock.f_51478_, (Comparable)rotation.m_55954_(Direction.SOUTH)));
                } else if ("ChestNorth".equals(p_230213_)) {
                    blockstate = (BlockState)((Object)blockstate.m_61124_((Property)ChestBlock.f_51478_, (Comparable)rotation.m_55954_(Direction.NORTH)));
                }
                this.m_226762_(p_230215_, p_230217_, p_230216_, p_230214_, BuiltInLootTables.f_78689_, blockstate);
            } else {
                ArrayList<Mob> list = new ArrayList<Mob>();
                switch (p_230213_) {
                    case "Mage": {
                        list.add((Mob)((Object)EntityType.f_20568_.m_20615_(p_230215_.m_6018_())));
                        break;
                    }
                    case "Warrior": {
                        list.add((Mob)EntityType.f_20493_.m_20615_(p_230215_.m_6018_()));
                        break;
                    }
                    case "Group of Allays": {
                        int i = p_230215_.m_213780_().m_188503_(3) + 1;
                        for (int j = 0; j < i; ++j) {
                            list.add((Mob)((Object)EntityType.f_217014_.m_20615_(p_230215_.m_6018_())));
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                for (Mob mob : list) {
                    mob.m_21530_();
                    mob.m_20035_(p_230214_, 0.0f, 0.0f);
                    if (!ForgeEventFactory.doSpecialSpawn((Mob)mob, (LevelAccessor)p_230215_, (float)((float)mob.m_20185_()), (float)((float)mob.m_20186_()), (float)((float)mob.m_20189_()), null, (MobSpawnType)MobSpawnType.STRUCTURE)) {
                        mob.m_6518_(p_230215_, p_230215_.m_6436_(mob.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                    }
                    p_230215_.m_47205_((Entity)mob);
                    p_230215_.m_7731_(p_230214_, Blocks.f_50016_.m_49966_(), 2);
                }
            }
        }
    }

    static class ThirdFloorRoomCollection
    extends SecondFloorRoomCollection {
        ThirdFloorRoomCollection() {
        }
    }

    static class SimpleGrid {
        private final int[][] f_230159_;
        final int f_230160_;
        final int f_230161_;
        private final int f_230162_;

        public SimpleGrid(int p_230164_, int p_230165_, int p_230166_) {
            this.f_230160_ = p_230164_;
            this.f_230161_ = p_230165_;
            this.f_230162_ = p_230166_;
            this.f_230159_ = new int[p_230164_][p_230165_];
        }

        public void m_230170_(int p_230171_, int p_230172_, int p_230173_) {
            if (p_230171_ >= 0 && p_230171_ < this.f_230160_ && p_230172_ >= 0 && p_230172_ < this.f_230161_) {
                this.f_230159_[p_230171_][p_230172_] = p_230173_;
            }
        }

        public void m_230179_(int p_230180_, int p_230181_, int p_230182_, int p_230183_, int p_230184_) {
            for (int i = p_230181_; i <= p_230183_; ++i) {
                for (int j = p_230180_; j <= p_230182_; ++j) {
                    this.m_230170_(j, i, p_230184_);
                }
            }
        }

        public int m_230167_(int p_230168_, int p_230169_) {
            return p_230168_ >= 0 && p_230168_ < this.f_230160_ && p_230169_ >= 0 && p_230169_ < this.f_230161_ ? this.f_230159_[p_230168_][p_230169_] : this.f_230162_;
        }

        public void m_230174_(int p_230175_, int p_230176_, int p_230177_, int p_230178_) {
            if (this.m_230167_(p_230175_, p_230176_) == p_230177_) {
                this.m_230170_(p_230175_, p_230176_, p_230178_);
            }
        }

        public boolean m_230185_(int p_230186_, int p_230187_, int p_230188_) {
            return this.m_230167_(p_230186_ - 1, p_230187_) == p_230188_ || this.m_230167_(p_230186_ + 1, p_230187_) == p_230188_ || this.m_230167_(p_230186_, p_230187_ + 1) == p_230188_ || this.m_230167_(p_230186_, p_230187_ - 1) == p_230188_;
        }
    }

    static class SecondFloorRoomCollection
    extends FloorRoomCollection {
        SecondFloorRoomCollection() {
        }

        @Override
        public String m_214126_(RandomSource p_230144_) {
            return "1x1_b" + (p_230144_.m_188503_(4) + 1);
        }

        @Override
        public String m_214127_(RandomSource p_230149_) {
            return "1x1_as" + (p_230149_.m_188503_(4) + 1);
        }

        @Override
        public String m_213986_(RandomSource p_230146_, boolean p_230147_) {
            return p_230147_ ? "1x2_c_stairs" : "1x2_c" + (p_230146_.m_188503_(4) + 1);
        }

        @Override
        public String m_213985_(RandomSource p_230151_, boolean p_230152_) {
            return p_230152_ ? "1x2_d_stairs" : "1x2_d" + (p_230151_.m_188503_(5) + 1);
        }

        @Override
        public String m_214128_(RandomSource p_230154_) {
            return "1x2_se" + (p_230154_.m_188503_(1) + 1);
        }

        @Override
        public String m_214124_(RandomSource p_230156_) {
            return "2x2_b" + (p_230156_.m_188503_(5) + 1);
        }

        @Override
        public String m_214125_(RandomSource p_230158_) {
            return "2x2_s1";
        }
    }

    static class PlacementData {
        public Rotation f_230138_;
        public BlockPos f_230139_;
        public String f_230140_;

        PlacementData() {
        }
    }

    static abstract class FloorRoomCollection {
        FloorRoomCollection() {
        }

        public abstract String m_214126_(RandomSource var1);

        public abstract String m_214127_(RandomSource var1);

        public abstract String m_213986_(RandomSource var1, boolean var2);

        public abstract String m_213985_(RandomSource var1, boolean var2);

        public abstract String m_214128_(RandomSource var1);

        public abstract String m_214124_(RandomSource var1);

        public abstract String m_214125_(RandomSource var1);
    }

    static class FirstFloorRoomCollection
    extends FloorRoomCollection {
        FirstFloorRoomCollection() {
        }

        @Override
        public String m_214126_(RandomSource p_229995_) {
            return "1x1_a" + (p_229995_.m_188503_(5) + 1);
        }

        @Override
        public String m_214127_(RandomSource p_230000_) {
            return "1x1_as" + (p_230000_.m_188503_(4) + 1);
        }

        @Override
        public String m_213986_(RandomSource p_229997_, boolean p_229998_) {
            return "1x2_a" + (p_229997_.m_188503_(9) + 1);
        }

        @Override
        public String m_213985_(RandomSource p_230002_, boolean p_230003_) {
            return "1x2_b" + (p_230002_.m_188503_(5) + 1);
        }

        @Override
        public String m_214128_(RandomSource p_230005_) {
            return "1x2_s" + (p_230005_.m_188503_(2) + 1);
        }

        @Override
        public String m_214124_(RandomSource p_230007_) {
            return "2x2_a" + (p_230007_.m_188503_(4) + 1);
        }

        @Override
        public String m_214125_(RandomSource p_230009_) {
            return "2x2_s1";
        }
    }
}

