/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.shape.Shape;
import org.popcraft.chunky.shape.ShapeFactory;
import org.popcraft.chunky.shape.ShapeType;
import org.popcraft.chunky.util.ChunkCoordinate;
import org.popcraft.chunky.util.Formatting;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Translator;

public class TrimCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public TrimCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        if (arguments.size() > 0) {
            Optional world = arguments.next().flatMap(arg -> Input.tryWorld(this.chunky, arg));
            if (world.isPresent()) {
                this.chunky.getSelection().world((World)world.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 1) {
            Optional shape = arguments.next().flatMap(Input::tryShape);
            if (shape.isPresent()) {
                this.chunky.getSelection().shape((String)shape.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 2) {
            Optional<Double> centerX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit(c));
            Optional<Double> centerZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(c -> !Input.isPastWorldLimit(c));
            if (centerX.isPresent() && centerZ.isPresent()) {
                this.chunky.getSelection().center(centerX.get(), centerZ.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 4) {
            Optional<Double> radiusX = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit(r));
            if (radiusX.isPresent()) {
                this.chunky.getSelection().radius(radiusX.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        if (arguments.size() > 5) {
            Optional<Double> radiusZ = arguments.next().flatMap(Input::tryDoubleSuffixed).filter(r -> r >= 0.0 && !Input.isPastWorldLimit(r));
            if (radiusZ.isPresent()) {
                this.chunky.getSelection().radiusZ(radiusZ.get());
            } else {
                sender.sendMessage("help_trim", new Object[0]);
                return;
            }
        }
        Selection selection = this.chunky.getSelection().build();
        Shape shape = ShapeFactory.getShape(selection);
        Runnable deletionAction = () -> this.chunky.getScheduler().runTask(() -> {
            long startTime;
            AtomicLong deleted;
            block24: {
                sender.sendMessagePrefixed("format_start", selection.world().getName(), Translator.translate("shape_" + selection.shape(), new Object[0]), Formatting.number(selection.centerX()), Formatting.number(selection.centerZ()), Formatting.radius(selection));
                Optional<Path> regionPath = selection.world().getRegionDirectory();
                Optional<Path> poiPath = selection.world().getPOIDirectory();
                Optional<Path> entitiesPath = selection.world().getEntitiesDirectory();
                deleted = new AtomicLong();
                startTime = System.currentTimeMillis();
                try {
                    if (regionPath.isPresent()) {
                        try (Stream<Path> regionWalker = Files.walk(regionPath.get(), new FileVisitOption[0]);){
                            regionWalker.forEach(region -> deleted.getAndAdd(this.checkRegion((Path)region, shape)));
                        }
                    }
                    if (poiPath.isPresent()) {
                        try (Stream<Path> poiWalker = Files.walk(poiPath.get(), new FileVisitOption[0]);){
                            poiWalker.forEach(region -> this.checkRegion((Path)region, shape));
                        }
                    }
                    if (!entitiesPath.isPresent()) break block24;
                    try (Stream<Path> entityWalker = Files.walk(entitiesPath.get(), new FileVisitOption[0]);){
                        entityWalker.forEach(region -> this.checkRegion((Path)region, shape));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            long totalTime = System.currentTimeMillis() - startTime;
            sender.sendMessagePrefixed("task_trim", deleted.get(), selection.world().getName(), String.format("%.3f", Float.valueOf((float)totalTime / 1000.0f)));
        });
        this.chunky.setPendingAction(sender, deletionAction);
        sender.sendMessagePrefixed("format_trim_confirm", selection.world().getName(), Translator.translate("shape_" + selection.shape(), new Object[0]), Formatting.number(selection.centerX()), Formatting.number(selection.centerZ()), Formatting.radius(selection), "/chunky confirm");
    }

    private int checkRegion(Path region, Shape shape) {
        int chunkZ;
        Optional<ChunkCoordinate> regionCoordinate = this.tryRegionCoordinate(region);
        if (regionCoordinate.isEmpty()) {
            return 0;
        }
        int chunkX = regionCoordinate.get().x() << 5;
        if (this.shouldDeleteRegion(shape, chunkX, chunkZ = regionCoordinate.get().z() << 5)) {
            return this.deleteRegion(region);
        }
        return this.trimRegion(region, shape, chunkX, chunkZ);
    }

    private Optional<ChunkCoordinate> tryRegionCoordinate(Path region) {
        String fileName = region.getFileName().toString();
        if (!fileName.startsWith("r.")) {
            return Optional.empty();
        }
        int extension = fileName.indexOf(".mca");
        if (extension < 2) {
            return Optional.empty();
        }
        String regionCoordinates = fileName.substring(2, extension);
        int separator = regionCoordinates.indexOf(46);
        Optional<Integer> regionX = Input.tryInteger(regionCoordinates.substring(0, separator));
        Optional<Integer> regionZ = Input.tryInteger(regionCoordinates.substring(separator + 1));
        if (regionX.isPresent() && regionZ.isPresent()) {
            return Optional.of(new ChunkCoordinate(regionX.get(), regionZ.get()));
        }
        return Optional.empty();
    }

    private boolean shouldDeleteRegion(Shape shape, int chunkX, int chunkZ) {
        for (int offsetX = 0; offsetX < 32; ++offsetX) {
            for (int offsetZ = 0; offsetZ < 32; ++offsetZ) {
                int chunkCenterX = (chunkX + offsetX << 4) + 8;
                int chunkCenterZ = (chunkZ + offsetZ << 4) + 8;
                if (!shape.isBounding(chunkCenterX, chunkCenterZ)) continue;
                return false;
            }
        }
        return true;
    }

    private int deleteRegion(Path region) {
        try {
            Files.deleteIfExists(region);
            return 1024;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int trimRegion(Path region, Shape shape, int chunkX, int chunkZ) {
        int deleted = 0;
        try (RandomAccessFile regionFile = new RandomAccessFile(region.toFile(), "rw");){
            if (regionFile.length() < 4096L) {
                int n = 0;
                return n;
            }
            int offsetX = 0;
            while (offsetX < 32) {
                for (int offsetZ = 0; offsetZ < 32; ++offsetZ) {
                    int chunkCenterX = (chunkX + offsetX << 4) + 8;
                    int chunkCenterZ = (chunkZ + offsetZ << 4) + 8;
                    if (shape.isBounding(chunkCenterX, chunkCenterZ)) continue;
                    int chunkLocation = (offsetX % 32 + offsetZ % 32 * 32) * 4;
                    regionFile.seek(chunkLocation);
                    if (regionFile.readInt() == 0) continue;
                    regionFile.seek(chunkLocation);
                    regionFile.writeInt(0);
                    ++deleted;
                }
                ++offsetX;
            }
            return deleted;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return deleted;
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        if (arguments.size() == 1) {
            ArrayList<String> suggestions = new ArrayList<String>();
            this.chunky.getServer().getWorlds().forEach(world -> suggestions.add(world.getName()));
            return suggestions;
        }
        if (arguments.size() == 2) {
            return ShapeType.ALL;
        }
        return List.of();
    }
}

