/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.internal;

import java.util.function.Function;
import net.minecraftforge.fart.api.Transformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

abstract class OptionalChangeTransformer
implements Transformer {
    protected final Function<ClassVisitor, ClassFixer> fixerFactory;

    protected OptionalChangeTransformer(Function<ClassVisitor, ClassFixer> fixerFactory) {
        this.fixerFactory = fixerFactory;
    }

    @Override
    public Transformer.ClassEntry process(Transformer.ClassEntry entry) {
        ClassReader reader = new ClassReader(entry.getData());
        ClassWriter writer = new ClassWriter(reader, 0);
        ClassFixer fixer = this.fixerFactory.apply(writer);
        reader.accept(fixer, 0);
        if (!fixer.madeChange()) {
            return entry;
        }
        return Transformer.ClassEntry.create(entry.getName(), entry.getTime(), writer.toByteArray());
    }

    protected static abstract class ClassFixer
    extends ClassVisitor {
        protected boolean madeChange = false;

        protected ClassFixer(ClassVisitor parent) {
            this(589824, parent);
        }

        protected ClassFixer(int api, ClassVisitor classVisitor) {
            super(api, classVisitor);
        }

        public boolean madeChange() {
            return this.madeChange;
        }
    }
}

