/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import net.minecraftforge.installertools.ChainMappings;
import net.minecraftforge.srgutils.IMappingFile;
import net.minecraftforge.srgutils.IRenamer;

public class MergeMappings
extends ChainMappings {
    @Override
    protected IRenamer makeRenamer(final IMappingFile link, final boolean classes, final boolean fields, final boolean methods, final boolean params) {
        return new IRenamer(){

            public String rename(IMappingFile.IPackage value) {
                return link.remapPackage(value.getOriginal());
            }

            public String rename(IMappingFile.IClass value) {
                return classes ? link.remapClass(value.getOriginal()) : value.getMapped();
            }

            public String rename(IMappingFile.IField value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getOriginal());
                return cls == null || !fields ? value.getMapped() : cls.remapField(value.getOriginal());
            }

            public String rename(IMappingFile.IMethod value) {
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)value.getParent()).getOriginal());
                return cls == null || !methods ? value.getMapped() : cls.remapMethod(value.getOriginal(), value.getDescriptor());
            }

            public String rename(IMappingFile.IParameter value) {
                IMappingFile.IMethod mtd = (IMappingFile.IMethod)value.getParent();
                IMappingFile.IClass cls = link.getClass(((IMappingFile.IClass)mtd.getParent()).getOriginal());
                mtd = cls == null ? null : cls.getMethod(mtd.getOriginal(), mtd.getDescriptor());
                return mtd == null || !params ? value.getMapped() : mtd.remapParameter(value.getIndex(), value.getMapped());
            }
        };
    }
}

