/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_19_R1.entity;

import java.util.UUID;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import org.apache.commons.lang.Validate;
import org.bukkit.craftbukkit.v1_19_R1.CraftServer;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftAnimals;
import org.bukkit.craftbukkit.v1_19_R1.inventory.CraftInventoryAbstractHorse;
import org.bukkit.entity.AbstractHorse;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Horse;
import org.bukkit.inventory.AbstractHorseInventory;

public abstract class CraftAbstractHorse
extends CraftAnimals
implements AbstractHorse {
    public CraftAbstractHorse(CraftServer server, net.minecraft.world.entity.animal.horse.AbstractHorse entity) {
        super(server, (Animal)entity);
    }

    public net.minecraft.world.entity.animal.horse.AbstractHorse getHandle() {
        return (net.minecraft.world.entity.animal.horse.AbstractHorse)this.entity;
    }

    @Override
    public void setVariant(Horse.Variant variant) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public int getDomestication() {
        return this.getHandle().m_30624_();
    }

    @Override
    public void setDomestication(int value) {
        Validate.isTrue((value >= 0 ? 1 : 0) != 0, (String)"Domestication cannot be less than zero");
        Validate.isTrue((value <= this.getMaxDomestication() ? 1 : 0) != 0, (String)"Domestication cannot be greater than the max domestication");
        this.getHandle().m_30649_(value);
    }

    @Override
    public int getMaxDomestication() {
        return this.getHandle().m_7555_();
    }

    @Override
    public void setMaxDomestication(int value) {
        Validate.isTrue((value > 0 ? 1 : 0) != 0, (String)"Max domestication cannot be zero or less");
        this.getHandle().maxDomestication = value;
    }

    @Override
    public double getJumpStrength() {
        return this.getHandle().m_30626_();
    }

    @Override
    public void setJumpStrength(double strength) {
        Validate.isTrue((strength >= 0.0 ? 1 : 0) != 0, (String)"Jump strength cannot be less than zero");
        this.getHandle().m_21051_(Attributes.f_22288_).m_22100_(strength);
    }

    @Override
    public boolean isTamed() {
        return this.getHandle().m_30614_();
    }

    @Override
    public void setTamed(boolean tamed) {
        this.getHandle().m_30651_(tamed);
    }

    @Override
    public AnimalTamer getOwner() {
        if (this.getOwnerUUID() == null) {
            return null;
        }
        return this.getServer().getOfflinePlayer(this.getOwnerUUID());
    }

    @Override
    public void setOwner(AnimalTamer owner) {
        if (owner != null) {
            this.setTamed(true);
            this.getHandle().setTarget(null, null, false);
            this.setOwnerUUID(owner.getUniqueId());
        } else {
            this.setTamed(false);
            this.setOwnerUUID(null);
        }
    }

    public UUID getOwnerUUID() {
        return this.getHandle().m_30615_();
    }

    public void setOwnerUUID(UUID uuid) {
        this.getHandle().m_30586_(uuid);
    }

    @Override
    public boolean isEatingHaystack() {
        return this.getHandle().m_30617_();
    }

    @Override
    public void setEatingHaystack(boolean eatingHaystack) {
        this.getHandle().m_30661_(eatingHaystack);
    }

    @Override
    public AbstractHorseInventory getInventory() {
        return new CraftInventoryAbstractHorse((Container)this.getHandle().f_30520_);
    }
}

