/*
 * Decompiled with CFR 0.152.
 */
package io.izzel.arclight.common.mixin.core.world.spawner;

import io.izzel.arclight.common.bridge.core.world.IWorldWriterBridge;
import io.izzel.arclight.common.bridge.core.world.WorldBridge;
import io.izzel.arclight.common.bridge.core.world.spawner.WorldEntitySpawnerBridge;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.LevelData;
import org.bukkit.craftbukkit.v1_19_R1.util.CraftSpawnCategory;
import org.bukkit.entity.SpawnCategory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public abstract class NaturalSpawnerMixin {
    @Shadow
    @Final
    private static MobCategory[] f_46979_;

    @Shadow
    public static void m_47045_(MobCategory p_234967_0_, ServerLevel p_234967_1_, LevelChunk p_234967_2_, NaturalSpawner.SpawnPredicate p_234967_3_, NaturalSpawner.AfterSpawnCallback p_234967_4_) {
    }

    @Overwrite
    public static void m_47029_(ServerLevel world, LevelChunk chunk, NaturalSpawner.SpawnState manager, boolean flag, boolean flag1, boolean flag2) {
        world.m_46473_().m_6180_("spawner");
        MobCategory[] classifications = f_46979_;
        LevelData worldInfo = world.m_6106_();
        for (MobCategory classification : classifications) {
            boolean spawnThisTick = true;
            int limit = classification.m_21608_();
            SpawnCategory spawnCategory = CraftSpawnCategory.toBukkit(classification);
            if (CraftSpawnCategory.isValidForLimits(spawnCategory)) {
                spawnThisTick = ((WorldBridge)world).bridge$ticksPerSpawnCategory().getLong((Object)spawnCategory) != 0L && worldInfo.m_6793_() % ((WorldBridge)world).bridge$ticksPerSpawnCategory().getLong((Object)spawnCategory) == 0L;
                limit = ((WorldBridge)world).bridge$getWorld().getSpawnLimit(spawnCategory);
            }
            if (!spawnThisTick || limit == 0 || !flag && classification.m_21609_() || !flag1 && !classification.m_21609_() || !flag2 && classification.m_21610_() || !((WorldEntitySpawnerBridge.EntityDensityManagerBridge)manager).bridge$canSpawn(classification, chunk.m_7697_(), limit)) continue;
            NaturalSpawnerMixin.m_47045_(classification, world, chunk, ((WorldEntitySpawnerBridge.EntityDensityManagerBridge)manager)::bridge$canSpawn, ((WorldEntitySpawnerBridge.EntityDensityManagerBridge)manager)::bridge$updateDensity);
        }
        world.m_46473_().m_7238_();
    }

    @Inject(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V")})
    private static void arclight$naturalSpawn(MobCategory p_234966_0_, ServerLevel worldIn, ChunkAccess p_234966_2_, BlockPos p_234966_3_, NaturalSpawner.SpawnPredicate p_234966_4_, NaturalSpawner.AfterSpawnCallback p_234966_5_, CallbackInfo ci) {
        ((WorldBridge)worldIn).bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.NATURAL);
    }

    @Redirect(method={"spawnCategoryForPosition(Lnet/minecraft/world/entity/MobCategory;Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/level/chunk/ChunkAccess;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/NaturalSpawner$SpawnPredicate;Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/NaturalSpawner$AfterSpawnCallback;run(Lnet/minecraft/world/entity/Mob;Lnet/minecraft/world/level/chunk/ChunkAccess;)V"))
    private static void arclight$skipRun(NaturalSpawner.AfterSpawnCallback afterSpawnCallback, Mob mob, ChunkAccess chunkAccess) {
        if (!mob.m_213877_()) {
            afterSpawnCallback.m_47100_(mob, chunkAccess);
        }
    }

    @Inject(method={"spawnMobsForChunkGeneration"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/ServerLevelAccessor;addFreshEntityWithPassengers(Lnet/minecraft/world/entity/Entity;)V")})
    private static void arclight$worldGenSpawn(ServerLevelAccessor accessor, Holder<Biome> p_151618_, ChunkPos p_151619_, RandomSource p_151620_, CallbackInfo ci) {
        ((IWorldWriterBridge)accessor).bridge$pushAddEntityReason(CreatureSpawnEvent.SpawnReason.CHUNK_GEN);
    }
}

