/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeparateTransformsModel
implements IUnbakedGeometry<SeparateTransformsModel> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BlockModel baseModel;
    private final ImmutableMap<ItemTransforms.TransformType, BlockModel> perspectives;
    private final boolean deprecatedLoader;

    public SeparateTransformsModel(BlockModel baseModel, ImmutableMap<ItemTransforms.TransformType, BlockModel> perspectives) {
        this(baseModel, perspectives, false);
    }

    private SeparateTransformsModel(BlockModel baseModel, ImmutableMap<ItemTransforms.TransformType, BlockModel> perspectives, boolean deprecatedLoader) {
        this.baseModel = baseModel;
        this.perspectives = perspectives;
        this.deprecatedLoader = deprecatedLoader;
    }

    @Override
    public BakedModel bake(IGeometryBakingContext context, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (this.deprecatedLoader) {
            LOGGER.warn("Model \"" + modelLocation + "\" is using the deprecated loader \"forge:separate-perspective\" instead of \"forge:separate_transforms\". This loader will be removed in 1.20.");
        }
        return new Baked(context.useAmbientOcclusion(), context.isGui3d(), context.useBlockLight(), spriteGetter.apply(context.getMaterial("particle")), overrides, this.baseModel.m_111449_(bakery, this.baseModel, spriteGetter, modelState, modelLocation, context.useBlockLight()), (ImmutableMap<ItemTransforms.TransformType, BakedModel>)ImmutableMap.copyOf((Map)Maps.transformValues(this.perspectives, value -> value.m_111449_(bakery, value, spriteGetter, modelState, modelLocation, context.useBlockLight()))));
    }

    @Override
    public Collection<Material> getMaterials(IGeometryBakingContext context, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet textures = Sets.newHashSet();
        if (context.hasMaterial("particle")) {
            textures.add(context.getMaterial("particle"));
        }
        textures.addAll(this.baseModel.m_5500_(modelGetter, missingTextureErrors));
        for (BlockModel model : this.perspectives.values()) {
            textures.addAll(model.m_5500_(modelGetter, missingTextureErrors));
        }
        return textures;
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final BakedModel baseModel;
        private final ImmutableMap<ItemTransforms.TransformType, BakedModel> perspectives;

        public Baked(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, BakedModel baseModel, ImmutableMap<ItemTransforms.TransformType, BakedModel> perspectives) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = overrides;
            this.baseModel = baseModel;
            this.perspectives = perspectives;
        }

        @Override
        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
            return this.baseModel.getQuads(state, side, rand, data, renderType);
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return this.overrides;
        }

        public ItemTransforms m_7442_() {
            return ItemTransforms.f_111786_;
        }

        public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack, boolean applyLeftHandTransform) {
            if (this.perspectives.containsKey((Object)cameraTransformType)) {
                BakedModel p = (BakedModel)this.perspectives.get((Object)cameraTransformType);
                return p.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
            }
            return this.baseModel.applyTransform(cameraTransformType, poseStack, applyLeftHandTransform);
        }

        public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
            return this.baseModel.getRenderTypes(state, rand, data);
        }
    }

    public static final class Loader
    implements IGeometryLoader<SeparateTransformsModel> {
        public static final Loader INSTANCE = new Loader(false);
        @Deprecated(forRemoval=true, since="1.19")
        public static final Loader INSTANCE_DEPRECATED = new Loader(true);
        private final boolean deprecated;

        private Loader(boolean deprecated) {
            this.deprecated = deprecated;
        }

        @Override
        public SeparateTransformsModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"base"), BlockModel.class);
            JsonObject perspectiveData = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"perspectives");
            HashMap<ItemTransforms.TransformType, BlockModel> perspectives = new HashMap<ItemTransforms.TransformType, BlockModel>();
            for (ItemTransforms.TransformType transform : ItemTransforms.TransformType.values()) {
                if (!perspectiveData.has(transform.getSerializeName())) continue;
                BlockModel perspectiveModel = (BlockModel)deserializationContext.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)perspectiveData, (String)transform.getSerializeName()), BlockModel.class);
                perspectives.put(transform, perspectiveModel);
            }
            return new SeparateTransformsModel(baseModel, (ImmutableMap<ItemTransforms.TransformType, BlockModel>)ImmutableMap.copyOf(perspectives), this.deprecated);
        }
    }
}

