/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;

public abstract class CustomizeGuiOverlayEvent
extends Event {
    private final Window window;
    private final PoseStack poseStack;
    private final float partialTick;

    @ApiStatus.Internal
    protected CustomizeGuiOverlayEvent(Window window, PoseStack poseStack, float partialTick) {
        this.window = window;
        this.poseStack = poseStack;
        this.partialTick = partialTick;
    }

    public Window getWindow() {
        return this.window;
    }

    public PoseStack getPoseStack() {
        return this.poseStack;
    }

    public float getPartialTick() {
        return this.partialTick;
    }

    public static class Chat
    extends CustomizeGuiOverlayEvent {
        private int posX;
        private int posY;

        @ApiStatus.Internal
        public Chat(Window window, PoseStack poseStack, float partialTick, int posX, int posY) {
            super(window, poseStack, partialTick);
            this.setPosX(posX);
            this.setPosY(posY);
        }

        public int getPosX() {
            return this.posX;
        }

        public void setPosX(int posX) {
            this.posX = posX;
        }

        public int getPosY() {
            return this.posY;
        }

        public void setPosY(int posY) {
            this.posY = posY;
        }
    }

    public static class DebugText
    extends CustomizeGuiOverlayEvent {
        private final ArrayList<String> left;
        private final ArrayList<String> right;

        @ApiStatus.Internal
        public DebugText(Window window, PoseStack poseStack, float partialTick, ArrayList<String> left, ArrayList<String> right) {
            super(window, poseStack, partialTick);
            this.left = left;
            this.right = right;
        }

        public ArrayList<String> getLeft() {
            return this.left;
        }

        public ArrayList<String> getRight() {
            return this.right;
        }
    }

    @Cancelable
    public static class BossEventProgress
    extends CustomizeGuiOverlayEvent {
        private final LerpingBossEvent bossEvent;
        private final int x;
        private final int y;
        private int increment;

        @ApiStatus.Internal
        public BossEventProgress(Window window, PoseStack poseStack, float partialTick, LerpingBossEvent bossEvent, int x, int y, int increment) {
            super(window, poseStack, partialTick);
            this.bossEvent = bossEvent;
            this.x = x;
            this.y = y;
            this.increment = increment;
        }

        public LerpingBossEvent getBossEvent() {
            return this.bossEvent;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getIncrement() {
            return this.increment;
        }

        public void setIncrement(int increment) {
            this.increment = increment;
        }
    }
}

