const $AttributeModifier = Java.loadClass("net.minecraft.world.entity.ai.attributes.AttributeModifier");

const WEAPON_DAMAGE = {
  "cataclysm:gauntlet_of_guard": 18,
  "cataclysm:gauntlet_of_bulwark": 18,
  "cataclysm:gauntlet_of_maelstrom": 18,
  "cataclysm:the_incinerator": 19,
  "cataclysm:soul_render": 48,
  "cataclysm:the_annihilator": 42,
  "cataclysm:the_immolator": 42,
  "cataclysm:meat_shredder": 14,
  "cataclysm:void_forge": 22,
  "cataclysm:astrape": 41,
  "cataclysm:ceraunus": 52,
  "cataclysm:tidal_claws": 18,
  "cataclysm:infernal_forge": 16,
  "cataclysm:ancient_spear": 19,

  "cataclysm_spellbooks:gauntlet_of_gattling": 20,
  "cataclysm_spellbooks:the_nightstalker": 20,
  "cataclysm_spellbooks:the_berserker": 20,
  "cataclysm_spellbooks:the_combuster": 20
}

ForgeEvents.onEvent("net.minecraftforge.event.ItemAttributeModifierEvent", event => {
  if (event.slotType != "mainhand") return

  let id = event.itemStack.id
  if (!WEAPON_DAMAGE[id]) return

  event.removeAttribute("minecraft:generic.attack_damage")

  let modifier = new $AttributeModifier(
    "133a6368-4778-4aa9-9025-fb3cba698200",
    "generic.attack_damage",
    WEAPON_DAMAGE[id],
    "ADDITION"
  )

  event.addModifier("minecraft:generic.attack_damage", modifier)
})