ItemEvents.modification(event => {
  [
    'minecraft:chainmail_helmet',
    'minecraft:chainmail_chestplate',
    'minecraft:chainmail_leggings',
    'minecraft:chainmail_boots',
  ].forEach(id => {
    event.modify(id, item => {
      item.armorProtection = 1; 

      item.armorToughness = 0.0;

      item.armorKnockbackResistance = 0.0;
    });
  });
});

//NERF AND BUFF ARMOR

ItemEvents.modification(event => {
  event.modify('ancient_elements:aeonite_helmet', item => {
    item.armorProtection = 10;
    item.armorToughness = 7;
    item.armorKnockbackResistance = 1;
  });
  event.modify('ancient_elements:aeonite_chestplate', item => {
    item.armorProtection = 15;
    item.armorToughness = 7;
    item.armorKnockbackResistance = 1;
  });
  event.modify('ancient_elements:aeonite_leggings', item => {
    item.armorProtection = 11;
    item.armorToughness = 7;
    item.armorKnockbackResistance = 1;
  });
  event.modify('ancient_elements:aeonite_boots', item => {
    item.armorProtection = 10;
    item.armorToughness = 7;
    item.armorKnockbackResistance = 1;
  });

  event.modify('bossesunleashed:celestial_jellyfish_mask', item => {
    item.armorProtection = 16;
    item.armorToughness = 10;
    item.armorKnockbackResistance = 1;
  });
  event.modify('bossesunleashed:celestial_jellyfish_chestplate', item => {
    item.armorProtection = 21;
    item.armorToughness = 10;
    item.armorKnockbackResistance = 1;
  });
  event.modify('bossesunleashed:celestial_jellyfish_leggings', item => {
    item.armorProtection = 18;
    item.armorToughness = 10;
    item.armorKnockbackResistance = 1;
  });
  event.modify('bossesunleashed:celestial_jellyfish_boots', item => {
    item.armorProtection = 16;
    item.armorToughness = 10;
    item.armorKnockbackResistance = 1;
  });

  event.modify('ancient_elements:galactrium_helmet', item => {
    item.armorProtection = 8;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('ancient_elements:galactrium_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('ancient_elements:galactrium_leggings', item => {
    item.armorProtection = 10;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('ancient_elements:galactrium_boots', item => {
    item.armorProtection = 7;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });

  event.modify('ancient_elements:celestium_helmet', item => {
    item.armorProtection = 7;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('ancient_elements:celestium_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('ancient_elements:celestium_leggings', item => {
    item.armorProtection = 8;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('ancient_elements:celestium_boots', item => {
    item.armorProtection = 6;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.5;
  });

  event.modify('armageddon_mod:helionite_armor_helmet', item => {
    item.armorProtection = 8;
    item.armorToughness = 8;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('armageddon_mod:helionite_armor_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 8;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('armageddon_mod:helionite_armor_leggings', item => {
    item.armorProtection = 11;
    item.armorToughness = 8;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('armageddon_mod:helionite_armor_boots', item => {
    item.armorProtection = 8;
    item.armorToughness = 8;
    item.armorKnockbackResistance = 0.5;
  });

  event.modify('terramity:exodium_warlock_helmet', item => {
    item.armorProtection = 8;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });
  event.modify('terramity:exodium_warlock_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });
  event.modify('terramity:exodium_warlock_leggings', item => {
    item.armorProtection = 11;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });
  event.modify('terramity:exodium_warlock_boots', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });

  event.modify('terramity:nyxium_knight_helmet', item => {
    item.armorProtection = 8;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });
  event.modify('terramity:nyxium_knight_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });
  event.modify('terramity:nyxium_knight_leggings', item => {
    item.armorProtection = 11;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });
  event.modify('terramity:nyxium_knight_boots', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.4;
  });

  event.modify('cataclysm_spellbooks:ignis_helmet', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:ignis_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:ignis_chestplate_elytra', item => {
    item.armorProtection = 13;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:ignis_leggings', item => {
    item.armorProtection = 10;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:ignis_boots', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });

  event.modify('cataclysm_spellbooks:cursium_mage_circlet', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:cursium_mage_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:cursium_mage_elytra', item => {
    item.armorProtection = 13;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:cursium_mage_skirt', item => {
    item.armorProtection = 10;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('cataclysm_spellbooks:cursium_mage_boots', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.2;
  });


  event.modify('armageddon_mod:elvenite_armor_helmet', item => {
    item.armorProtection = 3;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.1;
  });
  event.modify('armageddon_mod:elvenite_armor_chestplate', item => {
    item.armorProtection = 8;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.1;
  });
  event.modify('armageddon_mod:elvenite_armor_leggings', item => {
    item.armorProtection = 6;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.1;
  });
  event.modify('armageddon_mod:elvenite_armor_boots', item => {
    item.armorProtection = 3;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.1;
  });


  event.modify('armageddon_mod:voiderite_armor_helmet', item => {
    item.armorProtection = 5;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('armageddon_mod:voiderite_armor_chestplate', item => {
    item.armorProtection = 9;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('armageddon_mod:voiderite_armor_leggings', item => {
    item.armorProtection = 7;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.2;
  });
  event.modify('armageddon_mod:voiderite_armor_boots', item => {
    item.armorProtection = 5;
    item.armorToughness = 3;
    item.armorKnockbackResistance = 0.2;
  });

  event.modify('armageddon_mod:calamitous_armor_helmet', item => {
    item.armorProtection = 6;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
  });
  event.modify('armageddon_mod:calamitous_armor_chestplate', item => {
    item.armorProtection = 10;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
  });
  event.modify('armageddon_mod:calamitous_armor_leggings', item => {
    item.armorProtection = 8;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
  });
  event.modify('armageddon_mod:calamitous_armor_boots', item => {
    item.armorProtection = 6;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
  });

  event.modify('armageddon_mod:bloody_armor_helmet', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.5;

  });
  event.modify('armageddon_mod:bloody_armor_chestplate', item => {
    item.armorProtection = 11;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.5;

  });
  event.modify('armageddon_mod:bloody_armor_leggings', item => {
    item.armorProtection = 9;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.5;

  });
  event.modify('armageddon_mod:bloody_armor_boots', item => {
    item.armorProtection = 7;
    item.armorToughness = 5;
    item.armorKnockbackResistance = 0.5;

  });

  event.modify('composite_material:echoium_helmet', item => {
    item.armorProtection = 5;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
    item.maxDamage = 1460;
  });
  event.modify('composite_material:echoium_chestplate', item => {
    item.armorProtection = 10;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
    item.maxDamage = 2090;
  });
  event.modify('composite_material:echoium_leggings', item => {
    item.armorProtection = 7;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
    item.maxDamage = 2090;
  });
  event.modify('composite_material:echoium_boots', item => {
    item.armorProtection = 4;
    item.armorToughness = 4;
    item.armorKnockbackResistance = 0.3;
  });

  event.modify('composite_material:etherite_helmet', item => {
    item.armorProtection = 7;
    item.armorToughness = 6;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('composite_material:etherite_chestplate', item => {
    item.armorProtection = 13;
    item.armorToughness = 6;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('composite_material:etherite_leggings', item => {
    item.armorProtection = 10;
    item.armorToughness = 6;
    item.armorKnockbackResistance = 0.5;
  });
  event.modify('composite_material:etherite_boots', item => {
    item.armorProtection = 6;
    item.armorToughness = 6;
    item.armorKnockbackResistance = 0.5;
  });
});

ItemEvents.modification(e => {
  e.modify("lethality:nightmare_sword", item => {
    item.attackDamage = 78;
    item.attackSpeed = -3.6;
  });

  e.modify("lethality:gaels_greatsword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 65;
    item.attackSpeed = -3.2;
  });

  e.modify("lethality:hf_meowrasama", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 35;
  });

  e.modify("armageddon_mod:creative_obliterator", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 32;
    item.attackSpeed = -3;
  });

  e.modify("lethality:bladecrest_oathsword", item => {
    item.attackDamage = 11;
  });

  e.modify("composite_material:etherite_sword", item => {
    item.attackDamage = 17;
  });

  e.modify("composite_material:echoium_sword", item => {
    item.attackDamage = 12;
  });

  e.modify("composite_material:allay_steel_sword", item => {
    item.attackDamage = 6;
  });

  e.modify("terramity:sword_of_the_imprisoned", item => {
    item.attackDamage = 44;
    item.attackSpeed = -2.8;
  });

  e.modify("allthemodium:allthemodium_sword", item => {
    item.attackDamage = 8;
    item.attackSpeed = -2.4;
  });

  e.modify("allthemodium:vibranium_sword", item => {
    item.attackDamage = 10;
    item.attackSpeed = -2.4;
  });

  e.modify("allthemodium:unobtainium_sword", item => {
    item.attackDamage = 12;
    item.attackSpeed = -2.4;
  });
  
  e.modify("ancient_elements:celestium_sword", item => {
    item.attackDamage = 21;
  });

  e.modify("ancient_elements:galactrium_sword", item => {
    item.attackDamage = 25;
  });

  e.modify("ancient_elements:aeonite_sword", item => {
    item.attackDamage = 30;
    item.attackSpeed = -2;
  });

  e.modify("lethality:starlight", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 8;
  });

  e.modify("terramity:nyxium_greatsword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 16;
  });

  e.modify("terramity:exodium_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 14;
  });

  e.modify("terramity:reverium_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 14;
  });

  e.modify("terramity:excalibur", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 11;
  });

  e.modify("terramity:hero_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 18;
  });

  e.modify("enigmaticlegacy:etherium_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 16;
  });

  e.modify("lethality:vehemence", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 45;
  });

  e.modify("lethality:real_knife", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 24;
  });

  e.modify("lethality:violence", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 34;
  });

  e.modify("lethality:tainted_blade", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 9;
  });

  e.modify("lethality:caustic_edge", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 12;
  });

  e.modify("lethality:blighted_cleaver", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 14;
  });

  e.modify("lethality:defiled_greatsword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 18;
  });

  e.modify("lethality:forbidden_oathblade", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 20;
  });

  e.modify("lethality:exalted_oathblade", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 24;
  });

  e.modify("lethality:devils_devastation", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 29;
  });

  e.modify("brutality:royal_guardian_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 88;
    item.attackSpeed = -3.8;
  });

  e.modify("undergarden:forgotten_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 10;
  });

  e.modify("deepwaters:fopalsword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 40;
    item.maxDamage = 7999;
  });

  e.modify("armageddon_mod:helionite_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 28;
  });

  e.modify("armageddon_mod:bloody_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 16;
  });

  e.modify("armageddon_mod:voiderite_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 13;
  });

  e.modify("armageddon_mod:elvenite_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 11;
  });

  e.modify("armageddon_mod:true_helionite_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 36;
  });

  e.modify("armageddon_mod:the_duskfire_blade", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 44;
  });

  e.modify("armageddon_mod:lance_of_the_veil", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 48;
  });

  e.modify("deep_aether:stratus_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 9;
  });

  e.modify("block_factorys_bosses:knight_sword", item => {
    let currentDamage = item.attackDamage || 0;
    item.attackDamage = currentDamage + 28;
  });

  const $UUID = Java.loadClass("java.util.UUID");

  [
    "ancient_elements:aeonite_helmet",
    "ancient_elements:aeonite_chestplate",
    "ancient_elements:aeonite_leggings",
    "ancient_elements:aeonite_boots",
  ].forEach(id => {
    e.modify(id, item => {
      item.addAttribute(
        "minecraft:generic.max_health",
        $UUID.randomUUID(),
        "Max health",
        5.0,
        "addition"
      );
      item.addAttribute(
        "irons_spellbooks:spell_power",
        $UUID.randomUUID(),
        "Base Power",
        0.10,
        "multiply_base"
      );
    });
  });


  [
    "cataclysm:cursium_helmet",
    "cataclysm:cursium_chestplate",
    "cataclysm:cursium_leggings",
    "cataclysm:cursium_boots",
  ].forEach(id => {
    e.modify(id, item => {
      item.addAttribute(
        "minecraft:generic.armor",
        $UUID.randomUUID(),
        "Armor",
        4.0,
        "addition"
      );

      item.addAttribute(
        "minecraft:generic.armor_toughness",
        $UUID.randomUUID(),
        "Armor toughness",
        4.0,
        "addition"
      );

      item.addAttribute(
        "irons_spellbooks:spell_power",
        $UUID.randomUUID(),
        "Base Power",
        0.05,
        "multiply_base"
      );

      item.addAttribute(
        "minecraft:generic.max_health",
        $UUID.randomUUID(),
        "Max health",
        5.0,
        "addition"
      );
    });
  });

  [
    "bossesunleashed:celestial_jellyfish_mask",
    "bossesunleashed:celestial_jellyfish_chestplate",
    "bossesunleashed:celestial_jellyfish_leggings",
    "bossesunleashed:celestial_jellyfish_boots",
  ].forEach(id => {
    e.modify(id, item => {
     item.addAttribute(
        "irons_spellbooks:spell_power",
        $UUID.randomUUID(),
        "Base Power",
        0.10,
        "multiply_base"
      );

      item.addAttribute(
        "minecraft:generic.max_health",
        $UUID.randomUUID(),
        "Max health",
        5.0,
        "addition"
      );
    });
  });

  [
    "cataclysm:ignitium_helmet",
    "cataclysm:ignitium_elytra_chestplate",
    "cataclysm:ignitium_chestplate",
    "cataclysm:ignitium_leggings",
    "cataclysm:ignitium_boots",
  ].forEach(id => {
    e.modify(id, item => {
      item.addAttribute(
        "minecraft:generic.armor",
        $UUID.randomUUID(),
        "Armor",
        3.0,
        "addition"
      );

      item.addAttribute(
        "minecraft:generic.armor_toughness",
        $UUID.randomUUID(),
        "Armor toughness",
        2.0,
        "addition"
      );
    });
  });

  [
    "undergarden:utherium_helmet",
    "undergarden:utherium_chestplate",
    "undergarden:utherium_leggings",
    "undergarden:utherium_boots",
  ].forEach(id => {
    e.modify(id, item => {
      item.addAttribute(
        "minecraft:generic.armor",
        $UUID.randomUUID(),
        "Armor",
        1.0,
        "addition"
      );

      item.addAttribute(
        "minecraft:generic.armor_toughness",
        $UUID.randomUUID(),
        "Armor toughness",
        1.0,
        "addition"
      );
    });
  });

  [
    "deep_aether:stratus_helmet",
    "deep_aether:stratus_chestplate",
    "deep_aether:stratus_leggings",
    "deep_aether:stratus_boots",
  ].forEach(id => {
    e.modify(id, item => {
      item.addAttribute(
        "minecraft:generic.armor",
        $UUID.randomUUID(),
        "Armor",
        1.0,
        "addition"
      );

      item.addAttribute(
        "minecraft:generic.armor_toughness",
        $UUID.randomUUID(),
        "Armor toughness",
        1.0,
        "addition"
      );
    });
  });

  [
    "deep_aether:stormforged_helmet",
    "deep_aether:stormforged_chestplate",
    "deep_aether:stormforged_leggings",
    "deep_aether:stormforged_boots",
  ].forEach(id => {
    e.modify(id, item => {
      item.addAttribute(
        "minecraft:generic.armor",
        $UUID.randomUUID(),
        "Armor",
        1.0,
        "addition"
      );

      item.addAttribute(
        "minecraft:generic.armor_toughness",
        $UUID.randomUUID(),
        "Armor toughness",
        1.0,
        "addition"
      );
    });
  });
});