const AEONITE_ARMOR = [
  'ancient_elements:aeonite_helmet',
  'ancient_elements:aeonite_chestplate',
  'ancient_elements:aeonite_leggings',
  'ancient_elements:aeonite_boots',
  'ancient_elements:galactrium_helmet',
  'ancient_elements:galactrium_chestplate',
  'ancient_elements:galactrium_leggings',
  'ancient_elements:galactrium_boots',
  'armageddon_mod:helionite_armor_helmet',
  'armageddon_mod:helionite_armor_chestplate',
  'armageddon_mod:helionite_armor_leggings',
  'armageddon_mod:helionite_armor_boots',
  'lethality:hf_battle_maid_helmet',
  'lethality:hf_battle_maid_chestplate',
  'lethality:hf_battle_maid_leggings',
  'lethality:hf_battle_maid_boots',
  'armageddon_mod:bloody_armor_helmet',
  'armageddon_mod:bloody_armor_chestplate',
  'armageddon_mod:bloody_armor_leggings',
  'armageddon_mod:bloody_armor_boots'
]

const FIXED_MARKER = 'AeoniteUnbreakableFixed'

/**
 * @param {Internal.ItemStack} item
 * @returns {boolean} true wenn geändert
 */
const makeUnbreakable = (item) => {
  if (item.isEmpty()) return false
  if (!AEONITE_ARMOR.includes(item.id)) return false

  if (!item.nbt) item.nbt = {}
  if (item.nbt.Unbreakable === true) return false

  item.nbt.Unbreakable = true
  item.setDamageValue(0)
  item.nbt[FIXED_MARKER] = true

  return true
}


PlayerEvents.loggedIn(event => {
  const player = event.player
  let changed = false

  player.inventory.allItems.forEach(item => {
    if (makeUnbreakable(item)) changed = true
  })
})


ItemEvents.crafted(event => {
  makeUnbreakable(event.item)
})


ItemEvents.pickedUp(event => {
  makeUnbreakable(event.item)
})


PlayerEvents.inventoryChanged(event => {
  makeUnbreakable(event.item)
})
