const respawnTracker = new Map();

EntityEvents.spawned(event => {
    const player = event.entity;
    if(player && player.isPlayer()) {
        if(respawnTracker.has(player.id)) {
            player.server.schedule(10, () => {
                player.server.runCommandSilent(`tellraw @p {"text":"§cYou died! §7Use: §6/back §8- §7To teleport you to the place you've died!","color":"red"}`);
            });
            respawnTracker.delete(player.id)
        }
    }
});

EntityEvents.death(event => {
    const player = event.entity;
    if(player && player.isPlayer()) {
        respawnTracker.set(player.id, true);
    }
});
