BlockEvents.placed(event => {
  if (event.block.id !== 'armageddon_mod:bloody_block') return
  if (!event.player) return

  const player = event.player
  const data = player.persistentData

  const DONE_KEY = "bloodBlockCenterFix"

  if (data.getBoolean(DONE_KEY)) return

  const x = event.block.x
  const z = event.block.z

  if (Math.abs(x) <= 3 && Math.abs(z) <= 3) {
    data.putBoolean(DONE_KEY, true)

    player.give('kubejs:apollyon_top_left')

    player.runCommandSilent(
      'title @s actionbar {"text":"You feel a dark power flowing through you.","color":"dark_red"}'
    )
    player.runCommandSilent('ironsSpellbooks camera_shake ~ ~ ~ 100 20')
    player.runCommandSilent('playsound goety:apostle_death player @s')
  }
})



function handleShadowOrb(event) {
    const player = event.player
    const item = event.item
    if (!item || item.id !== 'darkdoppelganger:shadow_orb') return

    const data = player.persistentData

    const ORB_USED = "shadowOrbUsed"
    const CONFIRM = "shadowOrbConfirm"

    if (data.getBoolean(ORB_USED)) {
        event.cancel()
        return
    }

    if (!data.getBoolean(CONFIRM)) {
        data.putBoolean(CONFIRM, true)

        player.tell("§cAre you sure? Use the Shadow Orb again to transform it.")

        event.server.scheduleInTicks(20 * 5, () => {
            if (player && player.persistentData) {
                player.persistentData.putBoolean(CONFIRM, false)
            }
        })

        event.cancel()
        return
    }

    data.putBoolean(CONFIRM, false)
    data.putBoolean(ORB_USED, true)

    player.setHeldItem('main_hand', Item.of('minecraft:air'))

    player.give('kubejs:apollyon_bottom_left')

    player.tell("§aThe Shadow Orb has transformed into the Apollyon piece.")

    event.cancel()
}

ItemEvents.rightClicked(event => {
    if (event.player) {
        handleShadowOrb(event)
    }
})


