PlayerEvents.loggedIn(event => {
    const player = event.player
    const data = player.persistentData
    const now = Date.now()

    // Sofortige 10% Chance beim Join
    if (Math.random() <= 0.10) {
        triggerRandomEvent(player)
    }

    data.putLong("random30_next", now + 30 * 60 * 1000)
})


ServerEvents.tick(event => {
    const CHECK_INTERVAL = 20 * 300 // 5 Minuten

    if (event.server.tickCount % CHECK_INTERVAL !== 0) return

    event.server.players.forEach(player => {
        const data = player.persistentData
        const now = Date.now()
        const next = data.getLong("random30_next")

        if (now >= next) {

            if (Math.random() <= 0.10) {
                triggerRandomEvent(player)
            }

            data.putLong("random30_next", now + 30 * 60 * 1000)
        }
    })
})

function triggerRandomEvent(player) {
    const roll = Math.random()

    // 📩 Nachricht
    if (roll < 0.33) {
        const messages = [
            "§che can see you...",
            "§4he is here...",
            "§4there is no escape",
            "§4666",
            "§c666",
            "§cNO ESCAPE",
            "§4§kfdgölkädflökgölfdgölfgdfg",
            "§4§kfdgölkädflö",
            "§4§kfdgölkädflöfffff",
            "§4§kfdgölkädflökgölfdgölfgffffffffff",
            "§4can you defeat a god?"
        ]

        player.tell(messages[Math.floor(Math.random() * messages.length)])
    }

    // 🔊 Sound (stoppt nach 5 Sekunden)
    else if (roll < 0.66) {
        const sounds = [
            "goety:apostle_ambient",
            "goety:apostle_death",
            "goety:apostle_hurt",
            "goety:apostle_shade"
        ]

        const sound = sounds[Math.floor(Math.random() * sounds.length)]

        player.runCommandSilent(
            `playsound ${sound} master ${player.username}`
        )

        // ⏱️ Nach 5 Sekunden Sound stoppen
        event.server.scheduleInTicks(20 * 5, () => {
            if (player.isAlive()) {
                player.runCommandSilent(
                    `stopsound ${player.username} master`
                )
            }
        })
    }

    else {
        player.runCommandSilent(
            "ironsSpellbooks camera_shake ~ ~ ~ 100 20"
        )
    }

    if (Math.random() <= 0.30) {
        const titles = [
            "§4666",
            "§c666",
            "§4NO ESCAPE",
            "§4§k666§r §c666 §4§k666",
            "§4HE IS WATCHING",
            "§cYOU CANNOT HIDE"
        ]

        const title = titles[Math.floor(Math.random() * titles.length)]

        player.runCommandSilent(
            `title ${player.username} title {"text":"${title}"}`
        )
    }
}
