/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure.piece;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.ACStructurePieceRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.AbstractCaveGenerationStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;

public class FerrocaveStructurePiece
extends AbstractCaveGenerationStructurePiece {
    public FerrocaveStructurePiece(BlockPos chunkCorner, BlockPos holeCenter, int bowlHeight, int bowlRadius) {
        super((StructurePieceType)ACStructurePieceRegistry.FERROCAVE.get(), chunkCorner, holeCenter, bowlHeight, bowlRadius);
    }

    public FerrocaveStructurePiece(CompoundTag tag) {
        super((StructurePieceType)ACStructurePieceRegistry.FERROCAVE.get(), tag);
    }

    public FerrocaveStructurePiece(StructurePieceSerializationContext structurePieceSerializationContext, CompoundTag tag) {
        this(tag);
    }

    public void m_213694_(WorldGenLevel level, StructureManager featureManager, ChunkGenerator chunkGen, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        int cornerX = this.chunkCorner.m_123341_();
        int cornerY = this.chunkCorner.m_123342_();
        int cornerZ = this.chunkCorner.m_123343_();
        BlockPos.MutableBlockPos carve = new BlockPos.MutableBlockPos();
        BlockPos.MutableBlockPos carveAbove = new BlockPos.MutableBlockPos();
        carve.m_122178_(cornerX, cornerY, cornerZ);
        carveAbove.m_122178_(cornerX, cornerY, cornerZ);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 15; y >= 0; --y) {
                    carve.m_122178_(cornerX + x, Mth.m_14045_((int)(cornerY + y), (int)level.m_141937_(), (int)level.m_151558_()), cornerZ + z);
                    carveAbove.m_122178_(carve.m_123341_(), carve.m_123342_() + 1, carve.m_123343_());
                    if (!this.inCircle((BlockPos)carve) || this.checkedGetBlock(level, (BlockPos)carve).m_60713_(Blocks.f_50752_)) continue;
                    this.checkedSetBlock(level, (BlockPos)carve, Blocks.f_50627_.m_49966_());
                    this.surroundCornerOfLiquid(level, carve);
                }
            }
        }
    }

    private void surroundCornerOfLiquid(WorldGenLevel level, BlockPos.MutableBlockPos center) {
        BlockPos.MutableBlockPos offset = new BlockPos.MutableBlockPos();
        for (Direction dir : Direction.values()) {
            offset.m_122190_((Vec3i)center);
            offset.m_122173_(dir);
            BlockState state = this.checkedGetBlock(level, (BlockPos)offset);
            if (state.m_60819_().m_76178_()) continue;
            this.checkedSetBlock(level, (BlockPos)offset, ((Block)ACBlockRegistry.GALENA.get()).m_49966_());
        }
    }

    private boolean inCircle(BlockPos carve) {
        double targetRadius;
        float df1 = (ACMath.sampleNoise3D(carve.m_123341_(), carve.m_123342_(), carve.m_123343_(), 30.0f) + 1.0f) * 0.5f;
        float df2 = ACMath.sampleNoise3D(carve.m_123341_() - 1200, carve.m_123342_() + 100, carve.m_123343_() + 120, 10.0f) * 0.15f;
        float innerCircleOrb = ACMath.sampleNoise3D(carve.m_123341_() + 400, carve.m_123342_() + 40, carve.m_123343_() - 600, 20.0f);
        double df1Smooth = ACMath.smin(df1 + df2, 1.0f, 0.1f);
        double yDist = ACMath.smin(1.0f - (float)Math.abs(this.holeCenter.m_123342_() - carve.m_123342_()) / ((float)this.height * 0.5f), 1.0f, 0.3f);
        double distToCenter = carve.m_203202_((double)this.holeCenter.m_123341_(), (double)carve.m_123342_(), (double)this.holeCenter.m_123343_());
        return distToCenter < (targetRadius = yDist * ((double)this.radius * df1Smooth) * (double)this.radius) && (innerCircleOrb > -0.5f || innerCircleOrb < -0.75f);
    }
}

