/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.block.blockentity;

import com.github.alexmodguy.alexscaves.client.particle.ACParticleRegistry;
import com.github.alexmodguy.alexscaves.server.block.blockentity.ACBlockEntityRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TeslaBulbBlockEntity
extends BlockEntity {
    public int age = 0;
    private Vec3 lightningPos = null;
    private int strikeTime = 0;
    private boolean exploding;
    private float explodeProgress;
    private float prevExplodeProgress;
    private LightningBolt dummyBolt;

    public TeslaBulbBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ACBlockEntityRegistry.TESLA_BULB.get(), pos, state);
    }

    public static void tick(Level level, BlockPos blockPos, BlockState state, TeslaBulbBlockEntity entity) {
        ++entity.age;
        entity.prevExplodeProgress = entity.explodeProgress;
        if (entity.exploding && entity.explodeProgress < 10.0f) {
            entity.explodeProgress += 0.5f;
        } else if (!entity.exploding && entity.explodeProgress > 0.0f) {
            entity.explodeProgress -= 0.5f;
        }
        if (entity.exploding) {
            if (entity.explodeProgress == 10.0f) {
                level.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                if (!level.f_46443_) {
                    level.m_255391_(null, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, 7.0f, false, Level.ExplosionInteraction.BLOCK);
                }
                return;
            }
            if (level.f_46443_) {
                Vec3 from = Vec3.m_82512_((Vec3i)blockPos);
                for (int i = 0; i < 3 + level.f_46441_.m_188503_(3); ++i) {
                    Vec3 vec3 = entity.findStrikePos();
                    Vec3 to = vec3.m_82546_(from);
                    level.m_7106_((ParticleOptions)ACParticleRegistry.TESLA_BULB_LIGHTNING.get(), from.f_82479_, from.f_82480_, from.f_82481_, to.f_82479_, to.f_82480_, to.f_82481_);
                }
            } else if (entity.explodeProgress % 1.0f == 0.0f) {
                if (entity.dummyBolt == null) {
                    entity.dummyBolt = new LightningBolt(EntityType.f_20465_, level);
                    entity.dummyBolt.setDamage(1.0f);
                    entity.dummyBolt.m_20874_(true);
                }
                for (LivingEntity entity1 : level.m_45976_(LivingEntity.class, new AABB(blockPos.m_7918_(-5, -5, -5), blockPos.m_7918_(5, 5, 5)))) {
                    entity1.m_8038_((ServerLevel)level, entity.dummyBolt);
                    entity1.m_7311_(0);
                }
            }
        }
        if (!level.f_46443_) {
            if (entity.strikeTime > 0) {
                --entity.strikeTime;
                entity.lightningPos = null;
            } else if (entity.strikeTime < 0) {
                ++entity.strikeTime;
                if (entity.lightningPos != null && entity.strikeTime == -1) {
                    AABB aabb = new AABB(entity.lightningPos.m_82492_(1.0, 1.0, 1.0), entity.lightningPos.m_82520_(1.0, 1.0, 1.0));
                    if (entity.dummyBolt == null) {
                        entity.dummyBolt = new LightningBolt(EntityType.f_20465_, level);
                        entity.dummyBolt.setDamage(1.0f);
                        entity.dummyBolt.m_20874_(true);
                    }
                    for (LivingEntity entity1 : level.m_45976_(LivingEntity.class, aabb)) {
                        entity1.m_8038_((ServerLevel)level, entity.dummyBolt);
                        entity1.m_7311_(0);
                    }
                }
            } else {
                Vec3 vec3;
                entity.strikeTime = 15;
                if (level.m_213780_().m_188501_() < 0.4f && (vec3 = entity.findStrikePos()) != null) {
                    entity.strikeTime = -5;
                    entity.lightningPos = vec3;
                    Vec3 from = Vec3.m_82512_((Vec3i)blockPos);
                    Vec3 to = vec3.m_82546_(from);
                    ((ServerLevel)level).m_8767_((ParticleOptions)((SimpleParticleType)ACParticleRegistry.TESLA_BULB_LIGHTNING.get()), from.f_82479_, from.f_82480_, from.f_82481_, 0, to.f_82479_, to.f_82480_, to.f_82481_, 1.0);
                }
            }
        }
    }

    private Vec3 findStrikePos() {
        Vec3 center = Vec3.m_82512_((Vec3i)this.m_58899_());
        return center.m_82520_((double)(5 - this.f_58857_.f_46441_.m_188503_(10)), (double)(5 - this.f_58857_.f_46441_.m_188503_(10)), (double)(5 - this.f_58857_.f_46441_.m_188503_(10)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_7918_(-1, -1, -1), pos.m_7918_(2, 2, 2));
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.exploding = tag.m_128471_("Exploding");
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Exploding", this.exploding);
    }

    public float getExplodeProgress(float partialTicks) {
        return this.prevExplodeProgress + (this.explodeProgress - this.prevExplodeProgress) * partialTicks * 0.1f;
    }

    public void explode() {
        this.exploding = true;
    }
}

