/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.mixin;

import com.github.alexmodguy.alexscaves.AlexsCaves;
import com.github.alexmodguy.alexscaves.server.entity.ACEntityRegistry;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @Inject(method={"Lnet/minecraft/world/level/NaturalSpawner;spawnMobsForChunkGeneration(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/Holder;Lnet/minecraft/world/level/ChunkPos;Lnet/minecraft/util/RandomSource;)V"}, remap=true, at={@At(value="TAIL")})
    private static void ac_spawnMobsForChunkGeneration(ServerLevelAccessor level, Holder<Biome> surfaceBiome, ChunkPos chunkPos, RandomSource randomSource, CallbackInfo ci) {
        MobSpawnSettings mobspawnsettings;
        WeightedRandomList weightedrandomlist;
        Holder<Biome> caveBiome = NaturalSpawnerMixin.getCaveCreaturesBiome(level, chunkPos, randomSource);
        if (caveBiome != null && !(weightedrandomlist = (mobspawnsettings = ((Biome)caveBiome.m_203334_()).m_47518_()).m_151798_(ACEntityRegistry.CAVE_CREATURE)).m_146337_()) {
            int i = chunkPos.m_45604_();
            int j = chunkPos.m_45605_();
            while ((double)randomSource.m_188501_() < (Double)AlexsCaves.COMMON_CONFIG.caveCreatureSpawnCountModifier.get() * (double)mobspawnsettings.m_48344_()) {
                Optional optional = weightedrandomlist.m_216829_(randomSource);
                if (!optional.isPresent()) continue;
                MobSpawnSettings.SpawnerData mobspawnsettings$spawnerdata = (MobSpawnSettings.SpawnerData)optional.get();
                int mobsToSpawn = 1 + mobspawnsettings$spawnerdata.f_48406_ - mobspawnsettings$spawnerdata.f_48405_;
                int k = mobspawnsettings$spawnerdata.f_48405_ + randomSource.m_188503_(Math.max(mobsToSpawn, 1));
                SpawnGroupData spawngroupdata = null;
                int l = i + randomSource.m_188503_(16);
                int i1 = j + randomSource.m_188503_(16);
                int j1 = l;
                int k1 = i1;
                for (int l1 = 0; l1 < k; ++l1) {
                    boolean flag = false;
                    for (int i2 = 0; !flag && i2 < 4; ++i2) {
                        BlockPos blockpos = NaturalSpawnerMixin.getCaveCreatureSpawnPos(level, randomSource, caveBiome, mobspawnsettings$spawnerdata.f_48404_, l, i1);
                        if (mobspawnsettings$spawnerdata.f_48404_.m_20654_() && NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)mobspawnsettings$spawnerdata.f_48404_), (LevelReader)level, (BlockPos)blockpos, (EntityType)mobspawnsettings$spawnerdata.f_48404_)) {
                            Mob mob;
                            Entity entity;
                            float f = mobspawnsettings$spawnerdata.f_48404_.m_20678_();
                            double d0 = Mth.m_14008_((double)l, (double)((double)i + (double)f), (double)((double)i + 16.0 - (double)f));
                            double d1 = Mth.m_14008_((double)i1, (double)((double)j + (double)f), (double)((double)j + 16.0 - (double)f));
                            if (!level.m_45772_(mobspawnsettings$spawnerdata.f_48404_.m_20585_(d0, (double)blockpos.m_123342_(), d1)) || !SpawnPlacements.m_217074_((EntityType)mobspawnsettings$spawnerdata.f_48404_, (ServerLevelAccessor)level, (MobSpawnType)MobSpawnType.CHUNK_GENERATION, (BlockPos)BlockPos.m_274561_((double)d0, (double)blockpos.m_123342_(), (double)d1), (RandomSource)level.m_213780_())) continue;
                            try {
                                entity = mobspawnsettings$spawnerdata.f_48404_.m_20615_((Level)level.m_6018_());
                            }
                            catch (Exception exception) {
                                AlexsCaves.LOGGER.warn("Failed to create mob", (Throwable)exception);
                                continue;
                            }
                            entity.m_7678_(d0, (double)blockpos.m_123342_(), d1, randomSource.m_188501_() * 360.0f, 0.0f);
                            if (entity instanceof Mob && (mob = (Mob)entity).m_5545_((LevelAccessor)level, MobSpawnType.CHUNK_GENERATION) && mob.m_6914_((LevelReader)level)) {
                                spawngroupdata = mob.m_6518_(level, level.m_6436_(mob.m_20183_()), MobSpawnType.CHUNK_GENERATION, spawngroupdata, (CompoundTag)null);
                                level.m_47205_((Entity)mob);
                                flag = true;
                            }
                        }
                        l += randomSource.m_188503_(5) - randomSource.m_188503_(5);
                        i1 += randomSource.m_188503_(5) - randomSource.m_188503_(5);
                        while (l < i || l >= i + 16 || i1 < j || i1 >= j + 16) {
                            l = j1 + randomSource.m_188503_(5) - randomSource.m_188503_(5);
                            i1 = k1 + randomSource.m_188503_(5) - randomSource.m_188503_(5);
                        }
                    }
                }
            }
        }
    }

    private static Holder<Biome> getCaveCreaturesBiome(ServerLevelAccessor level, ChunkPos chunkPos, RandomSource random) {
        ArrayList<Holder> cavesWithCreatures = new ArrayList<Holder>();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(chunkPos.m_151390_(), -1, chunkPos.m_151393_());
        for (int i = 0; i < 5; ++i) {
            int heightRange = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, chunkPos.m_151390_(), chunkPos.m_151393_()) - level.m_141937_();
            int height = level.m_141937_() + Math.round((float)heightRange * random.m_188501_());
            mutableBlockPos.m_142448_(height);
            Holder holder = level.m_204166_((BlockPos)mutableBlockPos);
            if (((Biome)holder.get()).m_47518_().m_151798_(ACEntityRegistry.CAVE_CREATURE).m_146337_() || cavesWithCreatures.contains(holder)) continue;
            cavesWithCreatures.add(holder);
        }
        return cavesWithCreatures.isEmpty() ? null : (Holder)Util.m_214621_(cavesWithCreatures, (RandomSource)random);
    }

    private static BlockPos getCaveCreatureSpawnPos(ServerLevelAccessor level, RandomSource random, Holder<Biome> checkAgainst, EntityType<?> type, int x, int z) {
        int safeWorldHeight = Math.max(level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z), 0);
        int height = level.m_141937_() + random.m_188503_(2 + safeWorldHeight);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(x, height, z);
        while (!(level.m_8055_((BlockPos)mutableBlockPos).m_60795_() && level.m_204166_((BlockPos)mutableBlockPos) == checkAgainst || mutableBlockPos.m_123342_() <= level.m_141937_())) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        while (level.m_8055_((BlockPos)mutableBlockPos).m_60795_() && mutableBlockPos.m_123342_() > level.m_141937_()) {
            mutableBlockPos.m_122173_(Direction.DOWN);
        }
        return mutableBlockPos.m_7494_().m_7949_();
    }
}

