/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.render.entity;

import com.github.alexmodguy.alexscaves.client.model.WatcherModel;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.server.entity.living.WatcherEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WatcherRenderer
extends MobRenderer<WatcherEntity, WatcherModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("alexscaves:textures/entity/watcher.png");
    private static final ResourceLocation TEXTURE_MOTH = new ResourceLocation("alexscaves:textures/entity/watcher_moth.png");
    private static final ResourceLocation TEXTURE_EYESPOTS = new ResourceLocation("alexscaves:textures/entity/watcher_eyespots.png");

    public WatcherRenderer(EntityRendererProvider.Context renderManagerIn) {
        super(renderManagerIn, (EntityModel)new WatcherModel(), 0.5f);
        this.m_115326_(new LayerGlow());
    }

    protected void scale(WatcherEntity mob, PoseStack matrixStackIn, float partialTicks) {
    }

    public void render(WatcherEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        Direction direction;
        boolean shouldSit;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entity, (LivingEntityRenderer)this, partialTicks, poseStack, bufferSource, light))) {
            return;
        }
        poseStack.m_85836_();
        ((WatcherModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entity, partialTicks);
        ((WatcherModel)this.f_115290_).f_102609_ = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        ((WatcherModel)this.f_115290_).f_102610_ = entity.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entity.f_20884_, (float)entity.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entity.f_20886_, (float)entity.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && entity.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)entity.f_19860_, (float)entity.m_146909_());
        if (WatcherRenderer.m_194453_((LivingEntity)entity)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        if (entity.m_217003_(Pose.SLEEPING) && (direction = entity.m_21259_()) != null) {
            float f4 = entity.m_20236_(Pose.STANDING) - 0.1f;
            poseStack.m_252880_((float)(-direction.m_122429_()) * f4, 0.0f, (float)(-direction.m_122431_()) * f4);
        }
        float f7 = this.m_6930_((LivingEntity)entity, partialTicks);
        this.m_7523_((LivingEntity)entity, poseStack, f7, f, partialTicks);
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(entity, poseStack, partialTicks);
        poseStack.m_252880_(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entity.m_6084_()) {
            f8 = entity.f_267362_.m_267711_(partialTicks);
            f5 = entity.f_267362_.m_267590_(partialTicks);
            if (entity.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((WatcherModel)this.f_115290_).m_6839_((Entity)entity, f5, f8, partialTicks);
        ((WatcherModel)this.f_115290_).setupAnim(entity, f5, f8, f7, f2, f6);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.m_5933_((LivingEntity)entity);
        boolean flag1 = !flag && !entity.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_((Entity)entity);
        RenderType rendertype = this.getRenderType(entity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = bufferSource.m_6299_(rendertype);
            int i = WatcherRenderer.m_115338_((LivingEntity)entity, (float)this.m_6931_((LivingEntity)entity, partialTicks));
            float transparency = this.getWatcherTransparency(entity, partialTicks);
            ((WatcherModel)this.f_115290_).m_7695_(poseStack, vertexconsumer, light, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f * transparency : transparency);
        }
        if (!entity.m_5833_()) {
            for (RenderLayer renderlayer : this.f_115291_) {
                renderlayer.m_6494_(poseStack, bufferSource, light, (Entity)entity, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent((Entity)entity, entity.m_5446_(), (EntityRenderer)this, poseStack, bufferSource, light, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameTagEvent);
        if (renderNameTagEvent.getResult() != Event.Result.DENY && (renderNameTagEvent.getResult() == Event.Result.ALLOW || this.m_6512_((Mob)entity))) {
            this.m_7649_((Entity)entity, renderNameTagEvent.getContent(), poseStack, bufferSource, light);
        }
        poseStack.m_85849_();
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entity, (LivingEntityRenderer)this, partialTicks, poseStack, bufferSource, light));
    }

    private float getWatcherTransparency(WatcherEntity entity, float partialTicks) {
        return (1.0f - entity.getShadeAmount(partialTicks)) * 0.8f + 0.2f;
    }

    @Nullable
    protected RenderType getRenderType(WatcherEntity entity, boolean visible, boolean invisible, boolean glowing) {
        ResourceLocation resourcelocation = this.getTextureLocation(entity);
        return RenderType.m_110473_((ResourceLocation)resourcelocation);
    }

    public ResourceLocation getTextureLocation(WatcherEntity entity) {
        return TEXTURE;
    }

    class LayerGlow
    extends RenderLayer<WatcherEntity, WatcherModel> {
        public LayerGlow() {
            super((RenderLayerParent)WatcherRenderer.this);
        }

        public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, WatcherEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder1 = bufferIn.m_6299_(RenderType.m_110458_((ResourceLocation)TEXTURE_MOTH));
            ((WatcherModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder1, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(ACRenderTypes.getEyesAlphaEnabled(TEXTURE_EYESPOTS));
            ((WatcherModel)this.m_117386_()).m_7695_(poseStack, ivertexbuilder2, packedLightIn, LivingEntityRenderer.m_115338_((LivingEntity)entitylivingbaseIn, (float)0.0f), 1.0f, 1.0f, 1.0f, 0.66f);
        }
    }
}

