/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.model;

import com.github.alexmodguy.alexscaves.server.entity.living.SweetishFishEntity;
import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.google.common.collect.ImmutableList;

public class SweetishFishModel
extends AdvancedEntityModel<SweetishFishEntity> {
    private final AdvancedModelBox root;
    private final AdvancedModelBox bodySeg1;
    private final AdvancedModelBox bodySeg2;
    private final AdvancedModelBox tail;

    public SweetishFishModel() {
        this.texWidth = 32;
        this.texHeight = 32;
        this.root = new AdvancedModelBox((AdvancedEntityModel)this);
        this.root.setRotationPoint(0.0f, 24.0f, -2.0f);
        this.bodySeg1 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bodySeg1.setRotationPoint(0.0f, -2.5f, 0.0f);
        this.root.addChild((BasicModelPart)this.bodySeg1);
        this.bodySeg1.setTextureOffset(0, 0).addBox(-1.5f, -2.5f, -6.0f, 3.0f, 5.0f, 6.0f, 0.0f, false);
        this.bodySeg1.setTextureOffset(0, 0).addBox(0.0f, -4.5f, -2.0f, 0.0f, 2.0f, 2.0f, 0.0f, false);
        this.bodySeg2 = new AdvancedModelBox((AdvancedEntityModel)this);
        this.bodySeg2.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.bodySeg1.addChild((BasicModelPart)this.bodySeg2);
        this.bodySeg2.setTextureOffset(12, 6).addBox(0.0f, -4.5f, 0.0f, 0.0f, 2.0f, 5.0f, 0.0f, false);
        this.bodySeg2.setTextureOffset(0, 11).addBox(-1.5f, -2.5f, 0.0f, 3.0f, 5.0f, 6.0f, 0.0f, false);
        this.tail = new AdvancedModelBox((AdvancedEntityModel)this);
        this.tail.setRotationPoint(0.0f, 0.0f, 6.0f);
        this.bodySeg2.addChild((BasicModelPart)this.tail);
        this.tail.setTextureOffset(0, 18).addBox(0.0f, -3.5f, 0.0f, 0.0f, 7.0f, 4.0f, 0.0f, true);
        this.updateDefaultPose();
    }

    public Iterable<AdvancedModelBox> getAllParts() {
        return ImmutableList.of((Object)this.root, (Object)this.bodySeg1, (Object)this.bodySeg2, (Object)this.tail);
    }

    public Iterable<BasicModelPart> parts() {
        return ImmutableList.of((Object)this.root);
    }

    public void setupAnim(SweetishFishEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.resetToDefaultPose();
        float partialTicks = ageInTicks - (float)entity.f_19797_;
        float swimSpeed = 0.8f;
        float swimDegree = 0.85f;
        float flopSpeed = 0.7f;
        float flopDegree = 0.5f;
        float landProgress = entity.getLandProgress(partialTicks);
        float swimProgress = 1.0f - landProgress;
        float fishPitchAmount = entity.getFishPitch(partialTicks) / 57.295776f * swimProgress;
        this.progressRotationPrev(this.bodySeg1, landProgress, 0.0f, 0.0f, (float)Math.toRadians(-85.0), 1.0f);
        this.swing(this.bodySeg1, swimSpeed, 0.3f * swimDegree, false, 1.0f, 0.0f, limbSwing, swimProgress * limbSwingAmount);
        this.swing(this.bodySeg2, swimSpeed, 0.5f * swimDegree, false, -1.0f, 0.0f, limbSwing, swimProgress * limbSwingAmount);
        this.swing(this.tail, swimSpeed, swimDegree, false, -1.5f, 0.0f, limbSwing, swimProgress * limbSwingAmount);
        this.bob(this.bodySeg1, flopSpeed * 0.5f, flopDegree * 2.0f, true, ageInTicks, landProgress);
        this.swing(this.bodySeg1, flopSpeed, 0.3f * flopDegree, true, 1.0f, 0.0f, ageInTicks, landProgress);
        this.swing(this.bodySeg2, flopSpeed, 0.5f * flopDegree, false, -1.0f, 0.0f, ageInTicks, landProgress);
        this.swing(this.tail, flopSpeed, flopDegree, false, -3.0f, 0.0f, ageInTicks, landProgress);
        this.bodySeg1.rotateAngleX += fishPitchAmount * 0.9f;
    }
}

