/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.Goety;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class ModLootTables {
    private static final Set<ResourceLocation> LOCATIONS = Sets.newHashSet();
    private static final Set<ResourceLocation> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);
    public static final ResourceLocation EMPTY = new ResourceLocation("empty");
    public static final ResourceLocation CRYPT_TOMB = ModLootTables.register("chests/crypt_tomb");
    public static final ResourceLocation TALL_SKULL = ModLootTables.register("entities/tall_skull_mobs");
    public static final ResourceLocation PLAYER_WITCH = ModLootTables.register("entities/player_witch");
    public static final ResourceLocation CULTISTS = ModLootTables.register("entities/cultist_extra");
    public static final ResourceLocation CRYPT_SLIME = ModLootTables.register("entities/crypt_slime");
    public static final ResourceLocation TROPICAL_SLIME = ModLootTables.register("entities/tropical_slime");
    public static final ResourceLocation INFERNO = ModLootTables.register("entities/inferno_extra");
    public static final ResourceLocation APOSTLE_HARD = ModLootTables.register("entities/apostle_2");
    public static final ResourceLocation WITCH_BARTER = ModLootTables.register("gameplay/witch_bartering");
    public static final ResourceLocation WARLOCK_BARTER = ModLootTables.register("gameplay/warlock_bartering");
    public static final ResourceLocation MAVERICK_BARTER = ModLootTables.register("gameplay/maverick_bartering");
    public static final ResourceLocation HERETIC_BARTER = ModLootTables.register("gameplay/heretic_bartering");
    public static final ResourceLocation CRONE_BARTER = ModLootTables.register("gameplay/crone_bartering");
    public static final ResourceLocation TREASURE_POUCH = ModLootTables.register("gameplay/treasure_pouch");

    private static ResourceLocation register(String pId) {
        return ModLootTables.register(Goety.location(pId));
    }

    private static ResourceLocation register(ResourceLocation pId) {
        if (LOCATIONS.add(pId)) {
            return pId;
        }
        throw new IllegalArgumentException(pId + " is already a registered built-in loot table");
    }

    public static LootParams.Builder createLootParams(LivingEntity target, boolean checkPlayerKill, DamageSource source) {
        LivingEntity livingEntity;
        LootParams.Builder lootcontext$builder = new LootParams.Builder((ServerLevel)target.m_9236_()).m_287286_(LootContextParams.f_81455_, (Object)target).m_287286_(LootContextParams.f_81460_, (Object)target.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source).m_287289_(LootContextParams.f_81458_, (Object)source.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)source.m_7640_());
        if (checkPlayerKill && (livingEntity = target.m_21232_()) instanceof Player) {
            Player player = (Player)livingEntity;
            lootcontext$builder = lootcontext$builder.m_287286_(LootContextParams.f_81456_, (Object)player).m_287239_(player.m_36336_());
        }
        return lootcontext$builder;
    }

    public static void shuffleAndSplitItems(ObjectArrayList<ItemStack> p_230925_, int p_230926_, RandomSource p_230927_) {
        ArrayList list = Lists.newArrayList();
        ObjectListIterator iterator = p_230925_.iterator();
        while (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            if (itemstack.m_41619_()) {
                iterator.remove();
                continue;
            }
            if (itemstack.m_41613_() <= 1) continue;
            list.add(itemstack);
            iterator.remove();
        }
        while (p_230926_ - p_230925_.size() - list.size() > 0 && !list.isEmpty()) {
            ItemStack itemstack2 = (ItemStack)list.remove(Mth.m_216271_((RandomSource)p_230927_, (int)0, (int)(list.size() - 1)));
            int i = Mth.m_216271_((RandomSource)p_230927_, (int)1, (int)(itemstack2.m_41613_() / 2));
            ItemStack itemstack1 = itemstack2.m_41620_(i);
            if (itemstack2.m_41613_() > 1 && p_230927_.m_188499_()) {
                list.add(itemstack2);
            } else {
                p_230925_.add((Object)itemstack2);
            }
            if (itemstack1.m_41613_() > 1 && p_230927_.m_188499_()) {
                list.add(itemstack1);
                continue;
            }
            p_230925_.add((Object)itemstack1);
        }
        p_230925_.addAll((Collection)list);
        Util.m_214673_(p_230925_, (RandomSource)p_230927_);
    }

    public static void createLootChest(LivingEntity target, BlockState blockState, BlockPos blockPos, DamageSource cause) {
        if (target.f_19853_.m_7654_() != null) {
            ItemStack itemstack2;
            target.f_19853_.m_46597_(blockPos, blockState);
            LootParams lootParams = ModLootTables.createLootParams(target, true, cause).m_287235_(LootContextParamSets.f_81415_);
            LootTable table = target.f_19853_.m_7654_().m_278653_().m_278676_(target.m_5743_());
            ObjectArrayList lootItems = table.m_287195_(lootParams);
            List<Integer> availableSlots = ModLootTables.getAvailableSlots(target.m_217043_());
            ModLootTables.shuffleAndSplitItems((ObjectArrayList<ItemStack>)lootItems, availableSlots.size(), target.m_217043_());
            NonNullList finalLoot = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
            for (ItemStack itemstack2 : lootItems) {
                if (availableSlots.isEmpty()) continue;
                if (itemstack2.m_41619_()) {
                    finalLoot.set(availableSlots.remove(availableSlots.size() - 1).intValue(), (Object)ItemStack.f_41583_);
                    continue;
                }
                finalLoot.set(availableSlots.remove(availableSlots.size() - 1).intValue(), (Object)itemstack2);
            }
            itemstack2 = target.f_19853_.m_7702_(blockPos);
            if (itemstack2 instanceof Container) {
                Container container = (Container)itemstack2;
                for (int i = 0; i < container.m_6643_(); ++i) {
                    container.m_6836_(i, (ItemStack)finalLoot.get(i));
                }
            }
        }
    }

    public static List<Integer> getAvailableSlots(RandomSource random) {
        ObjectArrayList arrayList = new ObjectArrayList();
        for (int i = 0; i < 27; ++i) {
            arrayList.add((Object)i);
        }
        Util.m_214673_((ObjectArrayList)arrayList, (RandomSource)random);
        return arrayList;
    }

    public static Set<ResourceLocation> all() {
        return IMMUTABLE_LOCATIONS;
    }
}

