/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.capabilities.misc.IMisc;
import com.Polarice3.Goety.common.capabilities.misc.MiscCapUpdatePacket;
import com.Polarice3.Goety.common.capabilities.misc.MiscImp;
import com.Polarice3.Goety.common.capabilities.misc.MiscProvider;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.server.SPlayPlayerSoundPacket;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;

public class MiscCapHelper {
    public static IMisc getCapability(LivingEntity livingEntity) {
        return (IMisc)livingEntity.getCapability(MiscProvider.CAPABILITY).orElse((Object)new MiscImp());
    }

    public static boolean isFreezing(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).freezeLevel() > 0;
    }

    public static int freezeLevel(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).freezeLevel();
    }

    public static void setFreezing(LivingEntity livingEntity, int freeze) {
        MiscCapHelper.getCapability(livingEntity).setFreezeLevel(freeze);
        if (!livingEntity.f_19853_.f_46443_) {
            MiscCapHelper.sendMiscUpdatePacket(livingEntity);
        }
    }

    public static int getShields(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).shieldsLeft();
    }

    public static void setShields(LivingEntity livingEntity, int amount) {
        MiscCapHelper.getCapability(livingEntity).setShields(amount);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static void increaseShields(LivingEntity livingEntity) {
        MiscCapHelper.getCapability(livingEntity).increaseShields();
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static void decreaseShields(LivingEntity livingEntity) {
        MiscCapHelper.getCapability(livingEntity).breakShield();
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
        if (!livingEntity.f_19853_.f_46443_) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                ModNetwork.sendTo(player, new SPlayPlayerSoundPacket(SoundEvents.f_12347_, 1.0f, 1.0f));
            } else {
                livingEntity.m_5496_(SoundEvents.f_12347_, 1.0f, 1.0f);
            }
        }
    }

    public static int getShieldTime(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).shieldTime();
    }

    public static void setShieldTime(LivingEntity livingEntity, int time) {
        MiscCapHelper.getCapability(livingEntity).setShieldTime(time);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static void decreaseShieldTime(LivingEntity livingEntity) {
        MiscCapHelper.getCapability(livingEntity).decreaseShieldTime();
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static int getShieldCool(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).shieldCool();
    }

    public static void setShieldCool(LivingEntity livingEntity, int cool) {
        MiscCapHelper.getCapability(livingEntity).setShieldCool(cool);
    }

    public static void decreaseShieldCool(LivingEntity livingEntity) {
        MiscCapHelper.getCapability(livingEntity).decreaseShieldCool();
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static int getAmbientSoundTime(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).ambientSoundTime();
    }

    public static void doAmbientSoundTime(LivingEntity livingEntity) {
        MiscCapHelper.getCapability(livingEntity).increaseAmbientSoundTime();
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static void setAmbientSoundTime(LivingEntity livingEntity, int interval) {
        MiscCapHelper.getCapability(livingEntity).setAmbientSoundTime(interval);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static int getClientTargetID(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).getClientTargetID();
    }

    public static void setClientTargetID(LivingEntity livingEntity, int clientTargetID) {
        MiscCapHelper.getCapability(livingEntity).setClientTargetID(clientTargetID);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    @Nullable
    public static Entity getClientTarget(LivingEntity livingEntity) {
        return livingEntity.f_19853_.m_6815_(MiscCapHelper.getClientTargetID(livingEntity));
    }

    public static void setClientTarget(LivingEntity livingEntity, @Nullable Entity entity) {
        if (entity == null) {
            MiscCapHelper.setClientTargetID(livingEntity, 0);
        } else {
            MiscCapHelper.setClientTargetID(livingEntity, entity.m_19879_());
        }
    }

    public static int getMobTargetID(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).getMobTargetID();
    }

    public static void setMobTargetID(LivingEntity livingEntity, int mob) {
        MiscCapHelper.getCapability(livingEntity).setMobTargetID(mob);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    @Nullable
    public static Entity getMobTarget(LivingEntity livingEntity) {
        return livingEntity.f_19853_.m_6815_(MiscCapHelper.getMobTargetID(livingEntity));
    }

    public static void setMobTarget(LivingEntity livingEntity, @Nullable Entity entity) {
        if (entity == null) {
            MiscCapHelper.setMobTargetID(livingEntity, 0);
        } else {
            MiscCapHelper.setMobTargetID(livingEntity, entity.m_19879_());
        }
    }

    public static void updateMobTarget(Mob mob) {
        if (!mob.f_19853_.f_46443_ && MiscCapHelper.getMobTarget((LivingEntity)mob) != mob.m_5448_()) {
            MiscCapHelper.setMobTarget((LivingEntity)mob, (Entity)mob.m_5448_());
        }
    }

    public static int getNoHealTime(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).getNoHealTime();
    }

    public static void setNoHealTime(LivingEntity livingEntity, int seconds) {
        MiscCapHelper.getCapability(livingEntity).setNoHealTime(seconds);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static int getShakeTime(LivingEntity livingEntity) {
        return MiscCapHelper.getCapability(livingEntity).getShakeTime();
    }

    public static void setShakeTime(LivingEntity livingEntity, int ticks) {
        MiscCapHelper.getCapability(livingEntity).setShakeTime(ticks);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    @Nullable
    public static ResourceLocation getCustomSpinTexture(LivingEntity livingEntity) {
        String string = MiscCapHelper.getCapability(livingEntity).customSpinTexture();
        if (string.isEmpty()) {
            return null;
        }
        return new ResourceLocation(MiscCapHelper.getCapability(livingEntity).customSpinTexture());
    }

    public static void setCustomSpinTexture(LivingEntity livingEntity, @Nullable String string) {
        if (string == null) {
            string = "";
        }
        MiscCapHelper.getCapability(livingEntity).setCustomSpinTexture(string);
        MiscCapHelper.sendMiscUpdatePacket(livingEntity);
    }

    public static void clearGoals(GoalSelector goalSelector) {
        ArrayList<WrappedGoal> wrappedGoals = new ArrayList<WrappedGoal>(goalSelector.m_148105_());
        wrappedGoals.forEach(prioritizedGoal -> goalSelector.m_25363_(prioritizedGoal.m_26015_()));
    }

    public static CompoundTag save(CompoundTag tag, IMisc misc) {
        tag.m_128405_("freezeLevel", misc.freezeLevel());
        tag.m_128405_("shields", misc.shieldsLeft());
        tag.m_128405_("shieldTime", misc.shieldTime());
        tag.m_128405_("shieldCool", misc.shieldCool());
        tag.m_128405_("ambientSoundTime", misc.ambientSoundTime());
        tag.m_128405_("clientTargetID", misc.getClientTargetID());
        tag.m_128405_("mobTargetID", misc.getMobTargetID());
        if (misc.getNoHealTime() > 0) {
            tag.m_128405_("noHealTime", misc.getNoHealTime());
        }
        tag.m_128405_("shakeTime", misc.getShakeTime());
        tag.m_128359_("customSpinTexture", misc.customSpinTexture());
        return tag;
    }

    public static IMisc load(CompoundTag tag, IMisc misc) {
        if (tag.m_128441_("freezeLevel")) {
            misc.setFreezeLevel(tag.m_128451_("freezeLevel"));
        }
        if (tag.m_128441_("shields")) {
            misc.setShields(tag.m_128451_("shields"));
        }
        if (tag.m_128441_("shieldTime")) {
            misc.setShieldTime(tag.m_128451_("shieldTime"));
        }
        if (tag.m_128441_("shieldCool")) {
            misc.setShieldCool(tag.m_128451_("shieldCool"));
        }
        if (tag.m_128441_("ambientSoundTime")) {
            misc.setAmbientSoundTime(tag.m_128451_("ambientSoundTime"));
        }
        if (tag.m_128441_("clientTargetID")) {
            misc.setClientTargetID(tag.m_128451_("clientTargetID"));
        }
        if (tag.m_128441_("mobTargetID")) {
            misc.setMobTargetID(tag.m_128451_("mobTargetID"));
        }
        if (tag.m_128441_("noHealTime")) {
            misc.setNoHealTime(tag.m_128451_("noHealTime"));
        }
        if (tag.m_128441_("shakeTime")) {
            misc.setShakeTime(tag.m_128451_("shakeTime"));
        }
        if (tag.m_128441_("customSpinTexture")) {
            misc.setCustomSpinTexture(tag.m_128461_("customSpinTexture"));
        }
        return misc;
    }

    public static void sendMiscUpdatePacket(LivingEntity livingEntity) {
        if (!livingEntity.f_19853_.f_46443_) {
            ModNetwork.sentToTrackingEntityAndPlayer((Entity)livingEntity, new MiscCapUpdatePacket(livingEntity));
        }
    }
}

