/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.jei;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.crafting.ModRecipeSerializer;
import com.Polarice3.Goety.common.crafting.RitualRecipe;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.compat.jei.CursedInfuserCategory;
import com.Polarice3.Goety.compat.jei.JeiRecipeTypes;
import com.Polarice3.Goety.compat.jei.ModBrazierCategory;
import com.Polarice3.Goety.compat.jei.ModRitualCategory;
import com.Polarice3.Goety.compat.jei.PulverizeCategory;
import com.Polarice3.Goety.compat.jei.WitchBrewCategory;
import com.Polarice3.Goety.compat.jei.WitchBrewMaker;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.vanilla.IVanillaRecipeFactory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

@JeiPlugin
public class GoetyJeiPlugin
implements IModPlugin {
    public static IJeiHelpers jeiHelper;

    public void registerCategories(IRecipeCategoryRegistration registration) {
        jeiHelper = registration.getJeiHelpers();
        registration.addRecipeCategories(new IRecipeCategory[]{new CursedInfuserCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "animation")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "necroturgy")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "forge")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "geoturgy")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "magic")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "sabbath")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "adept_nether")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "expert_nether")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "end")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "frost")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "sky")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "storm")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModRitualCategory(registration.getJeiHelpers().getGuiHelper(), "deep")});
        registration.addRecipeCategories(new IRecipeCategory[]{new ModBrazierCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new PulverizeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new WitchBrewCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CURSED_INFUSER.get()), new RecipeType[]{JeiRecipeTypes.CURSED_INFUSER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GRIM_INFUSER.get()), new RecipeType[]{JeiRecipeTypes.CURSED_INFUSER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DARK_ALTAR.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.PEDESTAL.get()), new RecipeType[]{JeiRecipeTypes.RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.ANIMATION_CORE.get()), new RecipeType[]{JeiRecipeTypes.getRitual("animation")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_220855_), new RecipeType[]{JeiRecipeTypes.getRitual("necroturgy")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50322_), new RecipeType[]{JeiRecipeTypes.getRitual("forge")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50323_), new RecipeType[]{JeiRecipeTypes.getRitual("forge")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50324_), new RecipeType[]{JeiRecipeTypes.getRitual("forge")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_152490_), new RecipeType[]{JeiRecipeTypes.getRitual("geoturgy")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50201_), new RecipeType[]{JeiRecipeTypes.getRitual("magic")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50723_), new RecipeType[]{JeiRecipeTypes.getRitual("sabbath")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50730_), new RecipeType[]{JeiRecipeTypes.getRitual("adept_nether")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50197_), new RecipeType[]{JeiRecipeTypes.getRitual("expert_nether")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.VOID_BLOCK.get()), new RecipeType[]{JeiRecipeTypes.getRitual("end")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FREEZING_LAMP.get()), new RecipeType[]{JeiRecipeTypes.getRitual("frost")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.MARBLE_BLOCK.get()), new RecipeType[]{JeiRecipeTypes.getRitual("sky")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_152587_), new RecipeType[]{JeiRecipeTypes.getRitual("storm")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)Blocks.f_50378_), new RecipeType[]{JeiRecipeTypes.getRitual("deep")});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.NECRO_BRAZIER.get()), new RecipeType[]{JeiRecipeTypes.BRAZIER});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.PULVERIZE_FOCUS.get()), new RecipeType[]{JeiRecipeTypes.PULVERIZE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.BREWING_CAULDRON.get()), new RecipeType[]{JeiRecipeTypes.BREWING});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        ClientLevel world = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        RecipeManager recipeManager = world.m_7465_();
        IIngredientManager ingredientManager = registration.getIngredientManager();
        IVanillaRecipeFactory vanillaRecipeFactory = registration.getVanillaRecipeFactory();
        List cursedRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeSerializer.CURSED_INFUSER.get());
        registration.addRecipes(JeiRecipeTypes.CURSED_INFUSER, cursedRecipes);
        List ritualRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeSerializer.RITUAL_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.RITUAL, ritualRecipes);
        this.registerRitualType(registration, recipeManager, "animation");
        this.registerRitualType(registration, recipeManager, "necroturgy");
        this.registerRitualType(registration, recipeManager, "forge");
        this.registerRitualType(registration, recipeManager, "geoturgy");
        this.registerRitualType(registration, recipeManager, "magic");
        this.registerRitualType(registration, recipeManager, "sabbath");
        this.registerRitualType(registration, recipeManager, "adept_nether");
        this.registerRitualType(registration, recipeManager, "expert_nether");
        this.registerRitualType(registration, recipeManager, "end");
        this.registerRitualType(registration, recipeManager, "frost");
        this.registerRitualType(registration, recipeManager, "sky");
        this.registerRitualType(registration, recipeManager, "storm");
        this.registerRitualType(registration, recipeManager, "deep");
        List brazierRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeSerializer.BRAZIER_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.BRAZIER, brazierRecipes);
        List pulverizeRecipes = recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeSerializer.PULVERIZE_TYPE.get());
        registration.addRecipes(JeiRecipeTypes.PULVERIZE, pulverizeRecipes);
        registration.addRecipes(JeiRecipeTypes.BREWING, WitchBrewMaker.getRecipes(recipeManager, vanillaRecipeFactory, ingredientManager));
    }

    public void registerRitualType(IRecipeRegistration registration, RecipeManager recipeManager, String type) {
        this.registerRitualType(registration, recipeManager, type, type);
    }

    public void registerRitualType(IRecipeRegistration registration, RecipeManager recipeManager, String type, String type2) {
        registration.addRecipes(JeiRecipeTypes.getRitual(type), this.ritualTypeRecipe(recipeManager, type2));
    }

    public List<RitualRecipe> ritualTypeRecipe(RecipeManager recipeManager, String type) {
        return recipeManager.m_44013_((net.minecraft.world.item.crafting.RecipeType)ModRecipeSerializer.RITUAL_TYPE.get()).stream().filter(ritualRecipe -> ritualRecipe.getCraftType().contains(type)).toList();
    }

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("goety", "jei_plugin");
    }
}

