/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.compat.jei;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.Polarice3.Goety.common.crafting.CursedInfuserRecipes;
import com.Polarice3.Goety.compat.jei.JeiRecipeTypes;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CursedInfuserCategory
implements IRecipeCategory<CursedInfuserRecipes> {
    @Nonnull
    private final IDrawable background;
    private final IDrawable icon;
    private final Component localizedName;
    private final int regularCookTime;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CursedInfuserCategory(final IGuiHelper guiHelper) {
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.CURSED_INFUSER.get()));
        this.background = guiHelper.drawableBuilder(new ResourceLocation("goety", "textures/gui/jei/jei_gui.png"), 0, 220, 82, 36).addPadding(0, 0, 0, 0).build();
        this.regularCookTime = 400;
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(new ResourceLocation("goety", "textures/gui/jei/jei_gui.png"), 82, 128, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
        this.localizedName = Component.m_237115_((String)"gui.jei.category.cursed_infuser");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public RecipeType<CursedInfuserRecipes> getRecipeType() {
        return JeiRecipeTypes.CURSED_INFUSER;
    }

    public Component getTitle() {
        return this.localizedName;
    }

    public void draw(CursedInfuserRecipes recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        IDrawableAnimated arrow = this.getArrow(recipe);
        arrow.draw(stack, 24, 8);
        this.drawCookTime(recipe, stack, 30);
    }

    protected IDrawableAnimated getArrow(CursedInfuserRecipes recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = this.regularCookTime;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    protected void drawCookTime(CursedInfuserRecipes recipe, GuiGraphics matrixStack, int y) {
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.m_237110_((String)"gui.jei.category.cursed_infuser.time", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.m_91087_();
            Font fontRenderer = minecraft.f_91062_;
            int stringWidth = fontRenderer.m_92852_((FormattedText)timeString);
            matrixStack.m_280614_(fontRenderer, (Component)timeString, this.background.getWidth() - stringWidth, y, -8355712, false);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CursedInfuserRecipes recipe, IFocusGroup ingredients) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 9).addIngredients((Ingredient)recipe.m_7527_().get(0));
        if (recipe.isGrim()) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 30, 20).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.GRIM_INFUSER.get()}));
        } else {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 30, 20).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.CURSED_INFUSER.get()}));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 61, 9).addItemStack(recipe.m_8043_(null));
    }
}

