/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.world.structures;

import com.Polarice3.Goety.common.world.structures.ModStructureTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class BiggerJigsawStructure
extends Structure {
    public static final Codec<BiggerJigsawStructure> CODEC = RecordCodecBuilder.mapCodec(p_227640_ -> p_227640_.group((App)BiggerJigsawStructure.m_226567_((RecordCodecBuilder.Instance)p_227640_), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(p_227656_ -> p_227656_.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(p_227654_ -> p_227654_.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(p_227652_ -> p_227652_.maxDepth), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(p_227649_ -> p_227649_.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(p_227644_ -> p_227644_.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)1024).fieldOf("max_distance_from_center").forGetter(p_227642_ -> p_227642_.maxDistanceFromCenter)).apply((Applicative)p_227640_, BiggerJigsawStructure::new)).flatXmap(BiggerJigsawStructure.verifyRange(), BiggerJigsawStructure.verifyRange()).codec();
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;

    private static Function<BiggerJigsawStructure, DataResult<BiggerJigsawStructure>> verifyRange() {
        return p_227638_ -> {
            int i = switch (p_227638_.m_226620_()) {
                case TerrainAdjustment.NONE -> 0;
                case TerrainAdjustment.BURY, TerrainAdjustment.BEARD_THIN, TerrainAdjustment.BEARD_BOX -> 12;
                default -> throw new IncompatibleClassChangeError();
            };
            return p_227638_.maxDistanceFromCenter + i > 1024 ? DataResult.error(() -> "Structure size including terrain adaptation must not exceed 1024") : DataResult.success((Object)p_227638_);
        };
    }

    public BiggerJigsawStructure(Structure.StructureSettings p_227627_, Holder<StructureTemplatePool> p_227628_, Optional<ResourceLocation> p_227629_, int p_227630_, HeightProvider p_227631_, Optional<Heightmap.Types> p_227633_, int p_227634_) {
        super(p_227627_);
        this.startPool = p_227628_;
        this.startJigsawName = p_227629_;
        this.maxDepth = p_227630_;
        this.startHeight = p_227631_;
        this.projectStartToHeightmap = p_227633_;
        this.maxDistanceFromCenter = p_227634_;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext p_227636_) {
        ChunkPos chunkpos = p_227636_.f_226628_();
        int i = this.startHeight.m_213859_((RandomSource)p_227636_.f_226626_(), new WorldGenerationContext(p_227636_.f_226622_(), p_227636_.f_226629_()));
        BlockPos blockpos = new BlockPos(chunkpos.m_45604_(), i, chunkpos.m_45605_());
        return JigsawPlacement.m_227238_((Structure.GenerationContext)p_227636_, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)blockpos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ModStructureTypes.BIGGER_JIGSAW_STRUCTURE.get();
    }
}

