/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.client.audio.LoopSoundPlayer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SPlayLoopSoundPacket {
    private final SoundEvent soundEvent;
    private final int entity;
    private final float volume;
    private final float pitch;

    public SPlayLoopSoundPacket(Entity entity, SoundEvent soundEvent, float volume, float pitch) {
        this.entity = entity.m_19879_();
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SPlayLoopSoundPacket(int entity, SoundEvent soundEvent, float volume, float pitch) {
        this.entity = entity;
        this.soundEvent = soundEvent;
        this.volume = volume;
        this.pitch = pitch;
    }

    public static void encode(SPlayLoopSoundPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.entity);
        buffer.m_130085_(packet.soundEvent.m_11660_());
        buffer.writeFloat(packet.volume);
        buffer.writeFloat(packet.pitch);
    }

    public static SPlayLoopSoundPacket decode(FriendlyByteBuf buffer) {
        return new SPlayLoopSoundPacket(buffer.readInt(), SoundEvent.m_262824_((ResourceLocation)buffer.m_130281_()), buffer.readFloat(), buffer.readFloat());
    }

    public static void consume(SPlayLoopSoundPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Entity entity;
            ClientLevel clientWorld;
            if (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT && (clientWorld = Minecraft.m_91087_().f_91073_) != null && packet.entity >= 0 && (entity = clientWorld.m_6815_(packet.entity)) != null) {
                LoopSoundPlayer.playSound(entity, packet.soundEvent, packet.volume, packet.pitch);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

