/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.network.server;

import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.ParticleUtil;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;

public class SAddBrewParticlesPacket {
    private final ItemStack itemStack;
    private final BlockPos blockPos;
    private final boolean instant;
    private final int color;

    public SAddBrewParticlesPacket(ItemStack itemStack, BlockPos blockPos, boolean instant, int color) {
        this.itemStack = itemStack;
        this.blockPos = blockPos;
        this.instant = instant;
        this.color = color;
    }

    public static void encode(SAddBrewParticlesPacket packet, FriendlyByteBuf buffer) {
        buffer.writeItemStack(packet.itemStack, true);
        buffer.m_130064_(packet.blockPos);
        buffer.writeBoolean(packet.instant);
        buffer.writeInt(packet.color);
    }

    public static SAddBrewParticlesPacket decode(FriendlyByteBuf buffer) {
        return new SAddBrewParticlesPacket(buffer.m_130267_(), buffer.m_130135_(), buffer.readBoolean(), buffer.readInt());
    }

    public static void consume(SAddBrewParticlesPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ClientLevel clientWorld = Minecraft.m_91087_().f_91073_;
            if (clientWorld != null) {
                int area = BrewUtils.getAreaOfEffect(packet.itemStack) + 4;
                Vec3 vec3 = Vec3.m_82539_((Vec3i)packet.blockPos);
                for (int l = 0; l < 8; ++l) {
                    clientWorld.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)ModItems.SPLASH_BREW.get())), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, clientWorld.f_46441_.m_188583_() * 0.15, clientWorld.f_46441_.m_188500_() * 0.2, clientWorld.f_46441_.m_188583_() * 0.15);
                }
                float f0 = (float)(packet.color >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(packet.color >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(packet.color & 0xFF) / 255.0f;
                SimpleParticleType particleoptions = packet.instant ? ParticleTypes.f_123751_ : ParticleTypes.f_123806_;
                for (int j3 = 0; j3 < 100 * (BrewUtils.getAreaOfEffect(packet.itemStack) + 1); ++j3) {
                    float f3 = clientWorld.f_46441_.m_188501_() * (float)area;
                    float f4 = clientWorld.f_46441_.m_188501_() * (float)(Math.PI * (double)((float)area / 2.0f));
                    double d1 = Math.cos(f4) * (double)f3;
                    double d2 = 0.01 + clientWorld.f_46441_.m_188500_() * 0.5 + (double)area / 10.0;
                    double d3 = Math.sin(f4) * (double)f3;
                    Particle particle = ParticleUtil.addParticleInternal((ParticleOptions)particleoptions, particleoptions.m_6012_().m_123742_(), vec3.f_82479_ + d1 * 0.1, vec3.f_82480_ + 0.3, vec3.f_82481_ + d3 * 0.1, d1, d2, d3);
                    if (particle == null) continue;
                    float f5 = 0.75f + clientWorld.f_46441_.m_188501_() * 0.25f;
                    particle.m_107253_(f0 * f5, f1 * f5, f2 * f5);
                    particle.m_107268_(f3);
                }
                clientWorld.m_7785_((double)packet.blockPos.m_123341_(), (double)packet.blockPos.m_123342_(), (double)packet.blockPos.m_123343_(), SoundEvents.f_12436_, SoundSource.NEUTRAL, 1.0f, clientWorld.f_46441_.m_188501_() * 0.1f + 0.9f, false);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

