/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.wind;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.util.UpdraftBlast;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class UpdraftSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(1.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.UpdraftCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.UpdraftDuration.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.UpdraftCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.WIND;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int range = spellStat.getRange();
        double radius = spellStat.getRadius();
        if (this.rightStaff(staff)) {
            range *= 2;
            radius += 0.5;
        }
        float damage = ((Double)SpellConfig.UpdraftBlastDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
        if (WandUtil.enchantedFocus(caster)) {
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
            radius += (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster);
            damage += (float)WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
        }
        damage += (float)spellStat.getPotency();
        HitResult rayTraceResult = this.rayTrace((Level)worldIn, caster, range, radius);
        LivingEntity target = this.getTarget(caster, range);
        if (target != null) {
            UpdraftBlast updraftBlast = new UpdraftBlast((EntityType)ModEntityType.UPDRAFT_BLAST.get(), (Level)worldIn);
            updraftBlast.setOwner(caster);
            updraftBlast.setDamage(damage);
            updraftBlast.setAreaOfEffect((float)radius);
            updraftBlast.m_146884_(target.m_20182_());
            worldIn.m_7967_((Entity)updraftBlast);
        } else if (rayTraceResult instanceof BlockHitResult) {
            BlockPos blockPos = ((BlockHitResult)rayTraceResult).m_82425_();
            UpdraftBlast updraftBlast = new UpdraftBlast((EntityType)ModEntityType.UPDRAFT_BLAST.get(), (Level)worldIn);
            updraftBlast.setOwner(caster);
            updraftBlast.setDamage(damage);
            updraftBlast.setAreaOfEffect((float)radius);
            updraftBlast.m_6034_((float)blockPos.m_123341_() + 0.5f, (float)blockPos.m_123342_() + 1.0f, (float)blockPos.m_123343_() + 0.5f);
            worldIn.m_7967_((Entity)updraftBlast);
        }
    }
}

