/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.void_spells;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.util.VoidRift;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class VoidRiftSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setDuration(300).setRadius(0.0);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.RuptureCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.RuptureDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.VOID_PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.RuptureCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.VOID;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        return list;
    }

    @Override
    public void startSpell(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int warmUp = this.castDuration(caster, staff) - 10;
        int duration = spellStat.getDuration() * (WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1);
        int range = spellStat.getRange() + WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        Vec3 vec3 = this.rayTrace((Level)worldIn, caster, range, 3.0).m_82450_();
        VoidRift voidRift = new VoidRift((Level)worldIn, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        voidRift.setOwner(caster);
        voidRift.setDuration(duration);
        voidRift.setWarmUp(warmUp);
        voidRift.setStaff(this.rightStaff(staff));
        voidRift.setSize((float)(spellStat.getRadius() + (double)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster)));
        voidRift.setExtraDamage(spellStat.getPotency() + WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
        worldIn.m_7967_((Entity)voidRift);
    }
}

