/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.ElectroOrb;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ElectroOrbSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRange(32);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.ElectroOrbCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.ElectroOrbDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.ElectroOrbCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.RANGE.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        Vec3 vector3d;
        int potency = spellStat.getPotency();
        int range = spellStat.getRange();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            range += WandUtil.getLevels((Enchantment)ModEnchantments.RANGE.get(), caster);
        }
        LivingEntity livingEntity = this.getTarget(caster, range);
        ElectroOrb blast = new ElectroOrb((Level)worldIn, caster, livingEntity);
        if (livingEntity != null) {
            vector3d = livingEntity.m_20182_().m_82549_(livingEntity.m_20184_().m_82542_(10.0, 10.0, 10.0)).m_82546_(livingEntity.m_20182_()).m_82541_();
            blast.m_6034_(blast.m_20185_() + vector3d.f_82479_, caster.m_20188_() - 0.2, blast.m_20189_() + vector3d.f_82481_);
        } else {
            vector3d = caster.m_20252_(1.0f);
            blast.m_6034_(caster.m_20185_() + vector3d.f_82479_ / 2.0, caster.m_20188_() - 0.2, caster.m_20189_() + vector3d.f_82481_ / 2.0);
        }
        blast.setExtraDamage(potency);
        blast.setStaff(this.rightStaff(staff));
        blast.m_6686_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_, 0.66f, 3.0f);
        worldIn.m_7967_((Entity)blast);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.SHOCK_CAST.get());
    }
}

