/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.projectiles.MagmaBomb;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class MagmaSpell
extends Spell {
    @Override
    public SpellStat defaultStats() {
        return super.defaultStats().setRadius(3.0).setVelocity(1.5f);
    }

    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.MagmaBombCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.MagmaBombDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.PREPARE_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.MagmaBombCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        list.add((Enchantment)ModEnchantments.RADIUS.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        float radius = (float)spellStat.getRadius();
        float velocity = spellStat.getVelocity() + (float)WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster) / 3.0f;
        float extraBlast = (float)WandUtil.getLevels((Enchantment)ModEnchantments.RADIUS.get(), caster) / 2.0f;
        if (this.rightStaff(staff)) {
            radius += 1.0f;
        }
        MagmaBomb blast = new MagmaBomb(caster, (Level)worldIn);
        blast.setExtraDamage(spellStat.getPotency() + WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster));
        blast.setExplosionPower(extraBlast + radius);
        blast.setDuration(spellStat.getDuration() + WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster));
        blast.setStaff(this.rightStaff(staff));
        blast.m_37251_((Entity)caster, caster.m_146909_(), caster.m_146908_(), 0.0f, velocity, 1.0f);
        worldIn.m_7967_((Entity)blast);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.CAST_SPELL.get());
    }
}

