/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.nether;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.GhastServant;
import com.Polarice3.Goety.common.entities.ally.MiniGhast;
import com.Polarice3.Goety.common.entities.hostile.servants.Malghast;
import com.Polarice3.Goety.common.entities.neutral.SummonedFlying;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class GhastSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.GhastCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.GhastDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.GhastSummonDown.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.GhastCoolDown.get();
    }

    @Override
    public SoundEvent CastingSound(LivingEntity caster) {
        if (CuriosFinder.hasUnholySet(caster)) {
            return (SoundEvent)ModSounds.APOSTLE_PREPARE_SUMMON.get();
        }
        return (SoundEvent)ModSounds.PREPARE_SUMMON.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NETHER;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof Malghast;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.GhastLimit.get();
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public void commonResult(ServerLevel worldIn, LivingEntity caster) {
        if (this.isShifting(caster)) {
            for (Entity entity : worldIn.m_8583_()) {
                Malghast malghast;
                if (!(entity instanceof Malghast) || (malghast = (Malghast)entity).getTrueOwner() != caster || malghast.limitedLifeTicks <= 0) continue;
                malghast.lifeSpanDamage();
            }
            this.commonResultHit(worldIn, caster);
        }
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            int i = 3;
            if (this.rightStaff(staff)) {
                i = 3 + worldIn.f_46441_.m_188503_(3);
            }
            if (this.NetherPower(caster)) {
                i -= 2;
            }
            for (int i1 = 0; i1 < i; ++i1) {
                BlockPos blockpos = caster.m_20183_().m_7918_(-2 + caster.m_217043_().m_188503_(5), 1, -2 + caster.m_217043_().m_188503_(5));
                Malghast ghast = new MiniGhast((EntityType<? extends Malghast>)((EntityType)ModEntityType.MINI_GHAST.get()), (Level)worldIn);
                if (this.NetherPower(caster)) {
                    ghast = new GhastServant((EntityType<? extends Malghast>)((EntityType)ModEntityType.GHAST_SERVANT.get()), (Level)worldIn);
                    if (CuriosFinder.hasUnholySet(caster)) {
                        ghast = new Malghast((EntityType<? extends SummonedFlying>)((EntityType)ModEntityType.MALGHAST.get()), (Level)worldIn);
                    }
                    blockpos = BlockFinder.SummonFlyingRadius(caster.m_20183_().m_6630_(2), (LivingEntity)ghast, (Level)worldIn, 12);
                }
                ghast.setTrueOwner(caster);
                ghast.m_20035_(blockpos, caster.m_146908_(), 0.0f);
                ghast.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                ghast.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                this.SummonSap(caster, (LivingEntity)ghast);
                int boost = Mth.m_14045_((int)potency, (int)0, (int)10);
                ghast.setFireBallDamage(boost - EffectsUtil.getAmplifierPlus(caster, MobEffects.f_19613_));
                float extraBlast = (float)Mth.m_14045_((int)potency, (int)0, (int)((Integer)SpellConfig.MaxRadiusLevel.get())) / 2.5f;
                ghast.setExplosionPower(ghast.getExplosionPower() + extraBlast);
                this.setTarget(caster, (Mob)ghast);
                worldIn.m_7967_((Entity)ghast);
                this.summonAdvancement(caster, (LivingEntity)ghast);
            }
            this.SummonDown(caster);
            worldIn.m_6263_((Player)null, caster.m_20185_(), caster.m_20186_(), caster.m_20189_(), (SoundEvent)ModSounds.SUMMON_SPELL.get(), this.getSoundSource(), 1.0f, 1.0f);
        }
    }
}

