/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.necromancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.undead.skeleton.VanguardServant;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.common.magic.SummonSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class VanguardSpell
extends SummonSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.VanguardCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.VanguardDuration.get();
    }

    @Override
    public int SummonDownDuration() {
        return (Integer)SpellConfig.VanguardSummonDown.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return null;
    }

    @Override
    public SoundEvent loopSound(LivingEntity caster) {
        return (SoundEvent)ModSounds.VANGUARD_SPELL.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.VanguardCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.NECROMANCY;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.DURATION.get());
        return list;
    }

    @Override
    public Predicate<LivingEntity> summonPredicate() {
        return livingEntity -> livingEntity instanceof VanguardServant;
    }

    @Override
    public int summonLimit() {
        return (Integer)SpellConfig.VanguardLimit.get();
    }

    @Override
    public void commonResultHit(ServerLevel worldIn, LivingEntity caster) {
        for (int i = 0; i < caster.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
            worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.LICH.get()), caster.m_20185_(), caster.m_20188_(), caster.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.VANGUARD_SUMMON.get());
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        this.commonResult(worldIn, caster);
        int potency = spellStat.getPotency();
        int duration = spellStat.getDuration();
        if (WandUtil.enchantedFocus(caster)) {
            potency += WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            duration += WandUtil.getLevels((Enchantment)ModEnchantments.DURATION.get(), caster) + 1;
        }
        if (!this.isShifting(caster)) {
            if (staff.m_150930_((Item)ModItems.NAMELESS_STAFF.get())) {
                Vec3 vec3 = caster.m_20182_();
                Direction direction = caster.m_6350_();
                double stepX = direction.m_122429_();
                double stepZ = direction.m_122431_();
                for (int i1 = -3; i1 <= 3; ++i1) {
                    VanguardServant summonedentity = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), (Level)worldIn);
                    summonedentity.setTrueOwner(caster);
                    Vec3 vec32 = new Vec3(2.0 * stepX + (double)i1 * stepZ + vec3.m_7096_(), vec3.m_7098_(), 2.0 * stepZ + (double)i1 * stepX + vec3.m_7094_());
                    if (!worldIn.m_45756_((Entity)summonedentity, summonedentity.m_20191_().m_82383_(vec32))) {
                        vec32 = Vec3.m_82512_((Vec3i)BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, caster.f_19853_));
                    }
                    summonedentity.m_146884_(vec32);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    summonedentity.m_21530_();
                    summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                    this.buffSummon(caster, (LivingEntity)summonedentity, potency);
                    summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    summonedentity.m_5616_(caster.m_6080_());
                    summonedentity.m_146922_(caster.m_146908_());
                    this.SummonSap(caster, (LivingEntity)summonedentity);
                    this.setTarget(caster, (Mob)summonedentity);
                    if (worldIn.m_7967_((Entity)summonedentity)) {
                        ColorUtil colorUtil = new ColorUtil(11009086);
                        ServerParticleUtil.windShockwaveParticle(worldIn, colorUtil, 0.1f, 0.1f, 0.05f, -1, summonedentity.m_20182_());
                        worldIn.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.LICH.get()), summonedentity.m_20185_(), summonedentity.m_20186_(), summonedentity.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                        this.playSound(worldIn, (Entity)summonedentity, (SoundEvent)ModSounds.SOUL_EXPLODE.get(), 0.25f + worldIn.f_46441_.m_188501_() / 2.0f, 1.0f);
                        this.playSound(worldIn, (Entity)summonedentity, SoundEvents.f_11852_, 0.25f + worldIn.f_46441_.m_188501_() / 2.0f, 1.0f);
                    }
                    this.summonAdvancement(caster, (LivingEntity)summonedentity);
                }
            } else {
                int i = 1;
                if (this.rightStaff(staff)) {
                    i = 2 + caster.f_19853_.f_46441_.m_188503_(6);
                }
                for (int i1 = 0; i1 < i; ++i1) {
                    VanguardServant summonedentity = new VanguardServant((EntityType<? extends Summoned>)((EntityType)ModEntityType.VANGUARD_SERVANT.get()), (Level)worldIn);
                    summonedentity.setTrueOwner(caster);
                    summonedentity.m_20035_(BlockFinder.SummonRadius(caster.m_20183_(), (Entity)summonedentity, (Level)worldIn), 0.0f, 0.0f);
                    MobUtil.moveDownToGround((Entity)summonedentity);
                    summonedentity.m_21530_();
                    summonedentity.setLimitedLife(MobUtil.getSummonLifespan((Level)worldIn) * duration);
                    this.buffSummon(caster, (LivingEntity)summonedentity, potency);
                    summonedentity.m_6518_((ServerLevelAccessor)worldIn, caster.f_19853_.m_6436_(caster.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                    this.SummonSap(caster, (LivingEntity)summonedentity);
                    this.setTarget(caster, (Mob)summonedentity);
                    worldIn.m_7967_((Entity)summonedentity);
                    this.summonAdvancement(caster, (LivingEntity)summonedentity);
                }
            }
            this.SummonDown(caster);
            this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.VANGUARD_SUMMON.get());
        }
    }
}

