/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.geomancy;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.common.magic.BlockSpell;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class RotationSpell
extends BlockSpell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.RotationCost.get();
    }

    @Override
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.TOCK.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.RotationCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.GEOMANCY;
    }

    @Override
    public boolean rightBlock(ServerLevel worldIn, LivingEntity caster, BlockPos target, Direction direction) {
        return RotationSpell.blockCanRotate((Level)worldIn, target, direction);
    }

    @Override
    public void blockResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, BlockPos target, Direction direction) {
        worldIn.m_5594_(null, target, (SoundEvent)ModSounds.TOCK.get(), this.getSoundSource(), 1.0f, 1.0f);
    }

    public static boolean blockCanRotate(Level world, BlockPos pos, Direction side) {
        BlockState oldState = world.m_8055_(pos);
        BlockState newState = null;
        if (oldState.m_61138_((Property)BlockStateProperties.f_61401_)) {
            return false;
        }
        if (oldState.m_204336_(BlockTags.f_13031_)) {
            String key = "type";
            String valueDupe = "double";
            for (Property prop : oldState.m_61147_()) {
                if (!prop.m_61708_().equals("type") || !(newState = (BlockState)oldState.m_61122_(prop)).m_61143_(prop).toString().equals("double")) continue;
                newState = (BlockState)newState.m_61122_(prop);
            }
        } else if (oldState.m_61138_((Property)RotatedPillarBlock.f_55923_)) {
            Direction.Axis current = (Direction.Axis)oldState.m_61143_((Property)RotatedPillarBlock.f_55923_);
            switch (current) {
                case X: {
                    newState = (BlockState)oldState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y);
                    break;
                }
                case Y: {
                    newState = (BlockState)oldState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Z);
                    break;
                }
                case Z: {
                    newState = (BlockState)oldState.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.X);
                    break;
                }
            }
        } else if (oldState.m_61138_((Property)BlockStateProperties.f_61390_)) {
            newState = (BlockState)oldState.m_61124_((Property)BlockStateProperties.f_61390_, (Comparable)Integer.valueOf((Integer)oldState.m_61143_((Property)BlockStateProperties.f_61390_) + 1 & 0xF));
        } else if (oldState.m_61138_((Property)BlockStateProperties.f_61372_)) {
            newState = (BlockState)oldState.m_61124_((Property)BlockStateProperties.f_61372_, (Comparable)RotationSpell.changeFacing((Direction)oldState.m_61143_((Property)BlockStateProperties.f_61372_)));
        } else {
            switch (side) {
                case DOWN: 
                case UP: {
                    newState = oldState.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_180);
                    break;
                }
                case EAST: 
                case SOUTH: {
                    newState = oldState.rotate((LevelAccessor)world, pos, Rotation.CLOCKWISE_90);
                    break;
                }
                case NORTH: 
                case WEST: {
                    newState = oldState.rotate((LevelAccessor)world, pos, Rotation.COUNTERCLOCKWISE_90);
                    break;
                }
            }
        }
        if (oldState.m_61138_((Property)BedBlock.f_49440_) || oldState.m_61138_((Property)ChestBlock.f_51479_)) {
            newState = null;
        }
        boolean rotated = false;
        if (newState != null && newState.m_60710_((LevelReader)world, pos)) {
            rotated = world.m_46597_(pos, newState);
        }
        return rotated;
    }

    public static Direction changeFacing(Direction direction0) {
        return switch (direction0) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Direction.EAST;
            case Direction.EAST -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.WEST;
            case Direction.WEST -> Direction.UP;
            case Direction.UP -> Direction.DOWN;
            case Direction.DOWN -> Direction.NORTH;
        };
    }
}

